/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier.stubrunner;

import java.lang.invoke.MethodHandles;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.maven.verifier.stubrunner.AetherStubDownloaderFactory;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.BatchStubRunnerFactory;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;

@Named
public class RemoteStubRunner {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AetherStubDownloaderFactory aetherStubDownloaderFactory;

    @Inject
    public RemoteStubRunner(AetherStubDownloaderFactory aetherStubDownloaderFactory) {
        this.aetherStubDownloaderFactory = aetherStubDownloaderFactory;
    }

    public BatchStubRunner run(StubRunnerOptions options, RepositorySystemSession repositorySystemSession) {
        StubDownloader stubDownloader = this.aetherStubDownloaderFactory.build(repositorySystemSession).build(options);
        try {
            if (log.isDebugEnabled()) {
                log.debug("Launching StubRunner with args: " + options);
            }
            BatchStubRunner stubRunner = new BatchStubRunnerFactory(options, stubDownloader).buildBatchStubRunner();
            RunningStubs runningCollaborators = stubRunner.runStubs();
            log.info(runningCollaborators.toString());
            return stubRunner;
        }
        catch (Exception e) {
            log.error("An exception occurred while trying to execute the stubs: " + e.getMessage());
            throw e;
        }
    }
}

