/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.springframework.cloud.contract.maven.verifier.ChangeDetector;
import org.springframework.cloud.contract.maven.verifier.ManifestCreator;

@Mojo(name="generateStubs", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true)
public class GenerateStubsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File projectBuildDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true, required=true)
    private String projectFinalName;
    @Parameter(property="stubsDirectory", defaultValue="${project.build.directory}/stubs")
    private File outputDirectory;
    @Parameter(property="spring.cloud.contract.verifier.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="spring.cloud.contract.verifier.jar.skip", defaultValue="false")
    private boolean jarSkip;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter
    private String[] excludedFiles;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver archiver;
    @Parameter(defaultValue="stubs")
    private String classifier;
    @Parameter(property="incrementalContractStubsJar", defaultValue="true")
    private boolean incrementalContractStubsJar = true;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="failOnNoContracts", defaultValue="true")
    private boolean failOnNoContracts;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.jarSkip) {
            this.getLog().info((CharSequence)("Skipping Spring Cloud Contract Verifier execution: spring.cloud.contract.verifier.skip=" + this.skip + ", spring.cloud.contract.verifier.jar.skip=" + this.jarSkip));
            return;
        }
        if (this.stubsOutputMissing(this.outputDirectory) && !this.failOnNoContracts) {
            this.getLog().warn((CharSequence)"The stubs output directory is missing, the flag to fail on no stubs if off - will continue without throwing an exception");
            return;
        }
        if (this.stubsOutputMissing(this.outputDirectory) && this.failOnNoContracts) {
            throw new MojoExecutionException("Stubs could not be found: [" + this.outputDirectory.getAbsolutePath() + "] .\nPlease make sure that spring-cloud-contract:convert was invoked");
        }
        File stubsJarFile = this.getStubJarDestFile();
        if (this.incrementalContractStubsJar && !ChangeDetector.inputFilesChangeDetected(this.outputDirectory, this.mojoExecution, this.session)) {
            this.getLog().info((CharSequence)"Nothing to generate - stubs jar is up to date");
        } else {
            this.fillStubJar(this.outputDirectory, stubsJarFile);
        }
        this.projectHelper.attachArtifact(this.project, "jar", this.classifier, stubsJarFile);
    }

    private File getStubJarDestFile() {
        String stubArchiveName = this.projectFinalName + "-" + this.classifier + ".jar";
        return new File(this.projectBuildDirectory, stubArchiveName);
    }

    private void fillStubJar(File stubsOutputDir, File stubsJarFile) throws MojoFailureException {
        Object[] excludes = this.excludes();
        this.getLog().info((CharSequence)("Files matching this pattern will be excluded from stubs generation " + Arrays.toString(excludes)));
        try {
            this.archiver.addDirectory(stubsOutputDir, new String[]{"**/*.*"}, this.excludedFilesEmpty() ? new String[]{} : this.excludedFiles);
            this.archiver.setCompress(true);
            this.archiver.setDestFile(stubsJarFile);
            this.archiver.addConfiguredManifest(ManifestCreator.createManifest(this.project));
            this.archiver.createArchive();
        }
        catch (Exception e) {
            throw new MojoFailureException("Exception while packaging " + this.classifier + " jar.", (Throwable)e);
        }
    }

    private boolean stubsOutputMissing(File stubsOutputDir) {
        return !stubsOutputDir.exists();
    }

    private String[] excludes() {
        ArrayList<String> excludes = new ArrayList<String>();
        if (!this.excludedFilesEmpty()) {
            excludes.addAll(Arrays.asList(this.excludedFiles));
        }
        String[] array = new String[excludes.size()];
        array = excludes.toArray(array);
        return array;
    }

    private boolean excludedFilesEmpty() {
        return this.excludedFiles == null || this.excludedFiles.length == 0;
    }
}

