/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * <a href="https://guava.dev/EventBus">Discouraged</a> in favor of dependency injection and
 * concurrency frameworks, EventBus allows publish-subscribe-style communication.
 *
 * <p>See the Guava User Guide article on <a
 * href="https://github.shaded.shaded.com.google/guava/wiki/EventBusExplained">{@code EventBus}</a>.
 */
@CheckReturnValue
@ParametersAreNonnullByDefault
package shaded.shaded.com.google.common.eventbus;

import shaded.shaded.com.google.errorprone.annotations.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
