/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Set;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableSet;
import shaded.com.google.inject.Binder;
import shaded.com.google.inject.ConfigurationException;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.Provider;
import shaded.com.google.inject.TypeLiteral;
import shaded.com.google.inject.binder.AnnotatedBindingBuilder;
import shaded.com.google.inject.binder.ScopedBindingBuilder;
import shaded.com.google.inject.internal.AbstractBindingBuilder;
import shaded.com.google.inject.internal.BindingImpl;
import shaded.com.google.inject.internal.ConstructorBindingImpl;
import shaded.com.google.inject.internal.InstanceBindingImpl;
import shaded.com.google.inject.internal.LinkedBindingImpl;
import shaded.com.google.inject.internal.LinkedProviderBindingImpl;
import shaded.com.google.inject.internal.ProviderInstanceBindingImpl;
import shaded.com.google.inject.internal.Scoping;
import shaded.com.google.inject.spi.Element;
import shaded.com.google.inject.spi.InjectionPoint;
import shaded.com.google.inject.spi.Message;

public class BindingBuilder<T>
extends AbstractBindingBuilder<T>
implements AnnotatedBindingBuilder<T> {
    public BindingBuilder(Binder binder, List<Element> elements, Object source, Key<T> key) {
        super(binder, elements, source, key);
    }

    @Override
    public BindingBuilder<T> annotatedWith(Class<? extends Annotation> annotationType) {
        this.annotatedWithInternal(annotationType);
        return this;
    }

    @Override
    public BindingBuilder<T> annotatedWith(Annotation annotation) {
        this.annotatedWithInternal(annotation);
        return this;
    }

    @Override
    public BindingBuilder<T> to(Class<? extends T> implementation) {
        return this.to((Key)Key.get(implementation));
    }

    @Override
    public BindingBuilder<T> to(TypeLiteral<? extends T> implementation) {
        return this.to((Key)Key.get(implementation));
    }

    @Override
    public BindingBuilder<T> to(Key<? extends T> linkedKey) {
        Preconditions.checkNotNull(linkedKey, "linkedKey");
        this.checkNotTargetted();
        BindingImpl base = this.getBinding();
        this.setBinding(new LinkedBindingImpl<T>(base.getSource(), base.getKey(), base.getScoping(), linkedKey));
        return this;
    }

    @Override
    public void toInstance(T instance) {
        Set injectionPoints;
        this.checkNotTargetted();
        if (instance != null) {
            try {
                injectionPoints = InjectionPoint.forInstanceMethodsAndFields(instance.getClass());
            }
            catch (ConfigurationException e) {
                this.copyErrorsToBinder(e);
                injectionPoints = (Set)e.getPartialValue();
            }
        } else {
            this.binder.addError("Binding to null instances is not allowed. Use toProvider(Providers.of(null)) if this is your intended behaviour.", new Object[0]);
            injectionPoints = ImmutableSet.of();
        }
        BindingImpl base = this.getBinding();
        this.setBinding(new InstanceBindingImpl(base.getSource(), base.getKey(), Scoping.EAGER_SINGLETON, injectionPoints, instance));
    }

    @Override
    public BindingBuilder<T> toProvider(Provider<? extends T> provider) {
        return this.toProvider((javax.inject.Provider)provider);
    }

    @Override
    public BindingBuilder<T> toProvider(javax.inject.Provider<? extends T> provider) {
        Set injectionPoints;
        Preconditions.checkNotNull(provider, "provider");
        this.checkNotTargetted();
        try {
            injectionPoints = InjectionPoint.forInstanceMethodsAndFields(provider.getClass());
        }
        catch (ConfigurationException e) {
            this.copyErrorsToBinder(e);
            injectionPoints = (Set)e.getPartialValue();
        }
        BindingImpl base = this.getBinding();
        this.setBinding(new ProviderInstanceBindingImpl<T>(base.getSource(), base.getKey(), base.getScoping(), injectionPoints, provider));
        return this;
    }

    @Override
    public BindingBuilder<T> toProvider(Class<? extends javax.inject.Provider<? extends T>> providerType) {
        return this.toProvider((Key)Key.get(providerType));
    }

    @Override
    public BindingBuilder<T> toProvider(TypeLiteral<? extends javax.inject.Provider<? extends T>> providerType) {
        return this.toProvider((Key)Key.get(providerType));
    }

    @Override
    public BindingBuilder<T> toProvider(Key<? extends javax.inject.Provider<? extends T>> providerKey) {
        Preconditions.checkNotNull(providerKey, "providerKey");
        this.checkNotTargetted();
        BindingImpl base = this.getBinding();
        this.setBinding(new LinkedProviderBindingImpl(base.getSource(), base.getKey(), base.getScoping(), providerKey));
        return this;
    }

    @Override
    public <S extends T> ScopedBindingBuilder toConstructor(Constructor<S> constructor) {
        return this.toConstructor(constructor, TypeLiteral.get(constructor.getDeclaringClass()));
    }

    @Override
    public <S extends T> ScopedBindingBuilder toConstructor(Constructor<S> constructor, TypeLiteral<? extends S> type) {
        Set injectionPoints;
        Preconditions.checkNotNull(constructor, "constructor");
        Preconditions.checkNotNull(type, "type");
        this.checkNotTargetted();
        BindingImpl base = this.getBinding();
        try {
            injectionPoints = InjectionPoint.forInstanceMethodsAndFields(type);
        }
        catch (ConfigurationException e) {
            this.copyErrorsToBinder(e);
            injectionPoints = (Set)e.getPartialValue();
        }
        try {
            InjectionPoint constructorPoint = InjectionPoint.forConstructor(constructor, type);
            this.setBinding(new ConstructorBindingImpl(base.getKey(), base.getSource(), base.getScoping(), constructorPoint, injectionPoints));
        }
        catch (ConfigurationException e) {
            this.copyErrorsToBinder(e);
        }
        return this;
    }

    public String toString() {
        String string = String.valueOf(this.getBinding().getKey().getTypeLiteral());
        return new StringBuilder(16 + String.valueOf(string).length()).append("BindingBuilder<").append(string).append(">").toString();
    }

    private void copyErrorsToBinder(ConfigurationException e) {
        for (Message message : e.getErrorMessages()) {
            this.binder.addError(message);
        }
    }
}

