/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package shaded.shaded.org.apache.maven.model.path;

/**
 * Normalizes a URL to remove the ugly parent references "../" that got potentially inserted by URL adjustment during
 * model inheritance.
 *
 * @author Benjamin Bentmann
 */
public interface UrlNormalizer {

    /**
     * Normalizes the specified URL.
     *
     * @param url The URL to normalize, may be {@code null}.
     * @return The normalized URL or {@code null} if the input was {@code null}.
     */
    String normalize(String url);
}
