/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.RegexPatterns;

abstract class PatternValueDslProperty<T extends DslProperty>
implements GroovyObject {
    private final Random random;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public PatternValueDslProperty() {
        MetaClass metaClass;
        Random random;
        this.random = random = new Random();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    protected T createAndValidateProperty(Pattern pattern, Object object) {
        if (DefaultTypeTransformation.booleanUnbox((Object)object)) {
            String generatedValue = (String)ScriptBytecodeAdapter.asType((Object)object, String.class);
            boolean matches = pattern.matcher(generatedValue).matches();
            if (!matches) {
                throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{generatedValue, pattern.pattern()}, new String[]{"The generated value [", "] doesn't match the pattern [", "]"})));
            }
            return this.createProperty(pattern, generatedValue);
        }
        return this.createProperty(pattern, object);
    }

    protected abstract T createProperty(Pattern var1, Object var2);

    public T anyAlphaUnicode() {
        return this.createAndValidateProperty(RegexPatterns.ONLY_ALPHA_UNICODE, PatternValueDslProperty.randomString(20));
    }

    public T anyNumber() {
        return this.createAndValidateProperty(RegexPatterns.NUMBER, this.random.nextInt());
    }

    public T aBoolean() {
        return this.createAndValidateProperty(RegexPatterns.TRUE_OR_FALSE);
    }

    public T anyIpAddress() {
        return this.createAndValidateProperty(RegexPatterns.IP_ADDRESS);
    }

    public T anyHostname() {
        return this.createAndValidateProperty(RegexPatterns.HOSTNAME_PATTERN, StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"http://foo", (Object)this.random.nextInt()), (CharSequence)".com"));
    }

    public T anyEmail() {
        return this.createAndValidateProperty(RegexPatterns.EMAIL, StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"foo@bar", (Object)this.random.nextInt()), (CharSequence)".com"));
    }

    public T anyUrl() {
        return this.createAndValidateProperty(RegexPatterns.URL, StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"http://foo", (Object)this.random.nextInt()), (CharSequence)".com"));
    }

    public T anyUuid() {
        return this.createAndValidateProperty(RegexPatterns.UUID, UUID.randomUUID().toString());
    }

    public T anyDate() {
        int d = this.random.nextInt(8) + 1;
        return this.createAndValidateProperty(RegexPatterns.ANY_DATE, new GStringImpl(new Object[]{d, d, d}, new String[]{"201", "-0", "-1", ""}));
    }

    public T anyDateTime() {
        int d = this.random.nextInt(8) + 1;
        return this.createAndValidateProperty(RegexPatterns.ANY_DATE_TIME, new GStringImpl(new Object[]{d, d, d}, new String[]{"201", "-0", "-1", "T12:23:34"}));
    }

    public T anyTime() {
        int d = this.random.nextInt(9);
        return this.createAndValidateProperty(RegexPatterns.ANY_TIME, new GStringImpl(new Object[]{d, d}, new String[]{"12:2", ":3", ""}));
    }

    public T anyIso8601WithOffset() {
        int d = this.random.nextInt(8) + 1;
        return this.createAndValidateProperty(RegexPatterns.ISO8601_WITH_OFFSET, new GStringImpl(new Object[]{d, d, d}, new String[]{"201", "-0", "-1", "T12:23:34.123Z"}));
    }

    public T anyNonBlankString() {
        return this.createAndValidateProperty(RegexPatterns.NON_BLANK, PatternValueDslProperty.randomString(20));
    }

    public T anyNonEmptyString() {
        return this.createAndValidateProperty(RegexPatterns.NON_EMPTY, PatternValueDslProperty.randomString(20));
    }

    public T anyOf(String ... values) {
        return this.createAndValidateProperty(RegexPatterns.anyOf(values), BytecodeInterface8.objectArrayGet((Object[])values, (int)0));
    }

    private static String randomString(int length) {
        char[] characterSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        Random random = new Random();
        char[] result = new char[length];
        int i = 0;
        while (i < result.length) {
            int randomCharIndex = random.nextInt(characterSet.length);
            char c = BytecodeInterface8.cArrayGet((char[])characterSet, (int)randomCharIndex);
            BytecodeInterface8.cArraySet((char[])result, (int)i, (char)c);
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return new String(result);
    }

    protected T createAndValidateProperty(Pattern pattern) {
        return this.createAndValidateProperty(pattern, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PatternValueDslProperty.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

