/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.ToString;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;

@EqualsAndHashCode
@ToString(includePackage=false)
public class RegexPatterns
implements GroovyObject {
    protected static final Pattern TRUE_OR_FALSE;
    protected static final Pattern ONLY_ALPHA_UNICODE;
    protected static final Pattern NUMBER;
    protected static final Pattern IP_ADDRESS;
    protected static final Pattern HOSTNAME_PATTERN;
    protected static final Pattern EMAIL;
    protected static final Pattern URL;
    protected static final Pattern UUID;
    protected static final Pattern ANY_DATE;
    protected static final Pattern ANY_DATE_TIME;
    protected static final Pattern ANY_TIME;
    protected static final Pattern NON_EMPTY;
    protected static final Pattern NON_BLANK;
    protected static final Pattern ISO8601_WITH_OFFSET;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public RegexPatterns() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    protected static Pattern anyOf(String ... values) {
        public class _anyOf_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _anyOf_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return new GStringImpl(new Object[]{it}, new String[]{"^", "$"});
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _anyOf_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return Pattern.compile(DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object)values, (Closure)new _anyOf_closure1(RegexPatterns.class, RegexPatterns.class)), (String)"|"));
    }

    public String onlyAlphaUnicode() {
        return ONLY_ALPHA_UNICODE.pattern();
    }

    public String number() {
        return NUMBER.pattern();
    }

    public String anyBoolean() {
        return TRUE_OR_FALSE.pattern();
    }

    public String ipAddress() {
        return IP_ADDRESS.pattern();
    }

    public String hostname() {
        return HOSTNAME_PATTERN.pattern();
    }

    public String email() {
        return EMAIL.pattern();
    }

    public String url() {
        return URL.pattern();
    }

    public String uuid() {
        return UUID.pattern();
    }

    public String isoDate() {
        return ANY_DATE.pattern();
    }

    public String isoDateTime() {
        return ANY_DATE_TIME.pattern();
    }

    public String isoTime() {
        return ANY_TIME.pattern();
    }

    public String iso8601WithOffset() {
        return ISO8601_WITH_OFFSET.pattern();
    }

    public String nonEmpty() {
        return NON_EMPTY.pattern();
    }

    public String nonBlank() {
        return NON_BLANK.pattern();
    }

    public static String multipartParam(Object name, Object value) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name, value}, new String[]{".*--(.*)\r\nContent-Disposition: form-data; name=\"", "\"\r\n(Content-Type: .*\r\n)?(Content-Length: \\d+\r\n)?\r\n", "\r\n--\\1.*"}));
    }

    public static String multipartFile(Object name, Object filename, Object content) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name, filename, content}, new String[]{".*--(.*)\r\nContent-Disposition: form-data; name=\"", "\"; filename=\"", "\"\r\n(Content-Type: .*\r\n)?(Content-Length: \\d+\r\n)?\r\n", "\r\n--\\1.*"}));
    }

    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        return _result;
    }

    public boolean canEqual(Object other) {
        return other instanceof RegexPatterns;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof RegexPatterns)) {
            return false;
        }
        RegexPatterns otherTyped = (RegexPatterns)other;
        return !(!otherTyped.canEqual(this));
    }

    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("RegexPatterns(");
        _result.append(")");
        return _result.toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RegexPatterns.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Pattern pattern;
        Pattern pattern2;
        Pattern pattern3;
        Pattern pattern4;
        Pattern pattern5;
        Pattern pattern6;
        Pattern pattern7;
        Pattern pattern8;
        Pattern pattern9;
        Pattern pattern10;
        Pattern pattern11;
        Pattern pattern12;
        Pattern pattern13;
        Pattern pattern14;
        TRUE_OR_FALSE = pattern14 = Pattern.compile("(true|false)");
        ONLY_ALPHA_UNICODE = pattern13 = Pattern.compile("[\\p{L}]*");
        NUMBER = pattern12 = Pattern.compile("-?\\d*(\\.\\d+)?");
        IP_ADDRESS = pattern11 = Pattern.compile("([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])");
        HOSTNAME_PATTERN = pattern10 = Pattern.compile("((http[s]?|ftp):\\/)\\/?([^:\\/\\s]+)(:[0-9]{1,5})?");
        EMAIL = pattern9 = Pattern.compile("[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}");
        URL = pattern8 = Pattern.compile("((www\\.|(http|https|ftp|news|file)+\\:\\/\\/)[_.a-z0-9-]+\\.[a-z0-9\\/_:@=.+?,##%&~-]*[^.|\\'|\\# |!|\\(|?|,| |>|<|;|\\)])");
        UUID = pattern7 = Pattern.compile("[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}");
        ANY_DATE = pattern6 = Pattern.compile("(\\d\\d\\d\\d)-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])");
        ANY_DATE_TIME = pattern5 = Pattern.compile("([0-9]{4})-(1[0-2]|0[1-9])-(3[01]|0[1-9]|[12][0-9])T(2[0-3]|[01][0-9]):([0-5][0-9]):([0-5][0-9])");
        ANY_TIME = pattern4 = Pattern.compile("(2[0-3]|[01][0-9]):([0-5][0-9]):([0-5][0-9])");
        NON_EMPTY = pattern3 = Pattern.compile(".+");
        NON_BLANK = pattern2 = Pattern.compile(".*(\\S+|\\R).*|!^\\R*$");
        ISO8601_WITH_OFFSET = pattern = Pattern.compile("([0-9]{4})-(1[0-2]|0[1-9])-(3[01]|0[1-9]|[12][0-9])T(2[0-3]|[01][0-9]):([0-5][0-9]):([0-5][0-9])(\\.\\d{3})?(Z|[+-][01]\\d:[0-5]\\d)");
    }
}

