/*
 * Decompiled with CFR 0.152.
 */
package repackaged.nl.flotsam.xeger;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public class Xeger {
    private final Automaton automaton;
    private Random random;
    static int ITERATION_LIMIT = 200;

    public Xeger(String regex, Random random) {
        assert (regex != null);
        assert (random != null);
        String pattern = regex.replace("\\d", "[0-9]").replace("\\w", "[A-Za-z0-9_]").replace("\\s", "[ \t\r\n]");
        this.automaton = new RegExp(pattern).toAutomaton();
        this.random = random;
        String generatedCharsSysProp = System.getProperty("springCloudContractGeneratedCharsFromRegex");
        String generatedCharsEnvVar = System.getenv("SPRING_CLOUD_CONTRACT_GENERATED_CHARS_FROM_REGEX");
        if (StringUtils.isNotEmpty((CharSequence)generatedCharsSysProp)) {
            ITERATION_LIMIT = Integer.parseInt(generatedCharsSysProp);
        } else if (StringUtils.isNotEmpty((CharSequence)generatedCharsEnvVar)) {
            ITERATION_LIMIT = Integer.parseInt(generatedCharsEnvVar);
        }
    }

    public Xeger(String regex) {
        this(regex, new Random());
    }

    public String generate() {
        StringBuilder builder = new StringBuilder();
        int counter = 0;
        this.generate(builder, this.automaton.getInitialState(), counter);
        return builder.toString();
    }

    private void generate(StringBuilder builder, State state, int counter) {
        if (counter >= ITERATION_LIMIT) {
            return;
        }
        List transitions = state.getSortedTransitions(false);
        if (transitions.size() == 0) {
            assert (state.isAccept());
            return;
        }
        int nroptions = state.isAccept() ? transitions.size() : transitions.size() - 1;
        int option = Xeger.getRandomInt(0, nroptions, this.random);
        if (state.isAccept() && option == 0) {
            return;
        }
        Transition transition = (Transition)transitions.get(option - (state.isAccept() ? 1 : 0));
        this.appendChoice(builder, transition);
        this.generate(builder, transition.getDest(), ++counter);
    }

    private void appendChoice(StringBuilder builder, Transition transition) {
        char c = (char)Xeger.getRandomInt(transition.getMin(), transition.getMax(), this.random);
        builder.append(c);
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    static int getRandomInt(int min, int max, Random random) {
        int maxForRandom = max - min + 1;
        return random.nextInt(maxForRandom) + min;
    }
}

