/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.ToString;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;
import org.springframework.cloud.contract.spec.internal.UrlHelper;

@EqualsAndHashCode
@ToString(includePackage=false)
public class RegexPatterns
implements GroovyObject {
    protected static final Pattern TRUE_OR_FALSE;
    protected static final Pattern ALPHA_NUMERIC;
    protected static final Pattern ONLY_ALPHA_UNICODE;
    protected static final Pattern NUMBER;
    protected static final Pattern INTEGER;
    protected static final Pattern POSITIVE_INT;
    protected static final Pattern DOUBLE;
    protected static final Pattern HEX;
    protected static final Pattern IP_ADDRESS;
    protected static final Pattern HOSTNAME_PATTERN;
    protected static final Pattern EMAIL;
    protected static final Pattern URL;
    protected static final Pattern HTTPS_URL;
    protected static final Pattern UUID;
    protected static final Pattern ANY_DATE;
    protected static final Pattern ANY_DATE_TIME;
    protected static final Pattern ANY_TIME;
    protected static final Pattern NON_EMPTY;
    protected static final Pattern NON_BLANK;
    protected static final Pattern ISO8601_WITH_OFFSET;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public RegexPatterns() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    protected static Pattern anyOf(String ... values) {
        public class _anyOf_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _anyOf_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return new GStringImpl(new Object[]{it}, new String[]{"^", "$"});
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _anyOf_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return Pattern.compile(DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object)values, (Closure)new _anyOf_closure1(RegexPatterns.class, RegexPatterns.class)), (String)"|"));
    }

    public Pattern onlyAlphaUnicode() {
        return ONLY_ALPHA_UNICODE;
    }

    public Pattern alphaNumeric() {
        return ALPHA_NUMERIC;
    }

    public Pattern number() {
        return NUMBER;
    }

    public Pattern positiveInt() {
        return POSITIVE_INT;
    }

    public Pattern anyBoolean() {
        return TRUE_OR_FALSE;
    }

    public Pattern anInteger() {
        return INTEGER;
    }

    public Pattern aDouble() {
        return DOUBLE;
    }

    public Pattern ipAddress() {
        return IP_ADDRESS;
    }

    public Pattern hostname() {
        return HOSTNAME_PATTERN;
    }

    public Pattern email() {
        return EMAIL;
    }

    public Pattern url() {
        return URL;
    }

    public Pattern httpsUrl() {
        return HTTPS_URL;
    }

    public Pattern uuid() {
        return UUID;
    }

    public Pattern isoDate() {
        return ANY_DATE;
    }

    public Pattern isoDateTime() {
        return ANY_DATE_TIME;
    }

    public Pattern isoTime() {
        return ANY_TIME;
    }

    public Pattern iso8601WithOffset() {
        return ISO8601_WITH_OFFSET;
    }

    public Pattern nonEmpty() {
        return NON_EMPTY;
    }

    public Pattern nonBlank() {
        return NON_BLANK;
    }

    public static String multipartParam(Object name, Object value) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name, value}, new String[]{".*--(.*)\r\nContent-Disposition: form-data; name=\"", "\"\r\n(Content-Type: .*\r\n)?(Content-Transfer-Encoding: .*\r\n)?(Content-Length: \\d+\r\n)?\r\n", "\r\n--\\1.*"}));
    }

    public static String multipartFile(Object name, Object filename, Object content, Object contentType) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name, filename, RegexPatterns.toContentType(contentType), content}, new String[]{".*--(.*)\r\nContent-Disposition: form-data; name=\"", "\"; filename=\"", "\"\r\n(Content-Type: ", "\r\n)?(Content-Transfer-Encoding: .*\r\n)?(Content-Length: \\d+\r\n)?\r\n", "\r\n--\\1.*"}));
    }

    private static String toContentType(Object contentType) {
        if (contentType == null) {
            return ".*";
        }
        if (contentType instanceof Pattern) {
            return ((Pattern)contentType).pattern();
        }
        return DefaultGroovyMethods.toString((Object)contentType);
    }

    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        return _result;
    }

    public boolean canEqual(Object other) {
        return other instanceof RegexPatterns;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof RegexPatterns)) {
            return false;
        }
        RegexPatterns otherTyped = (RegexPatterns)other;
        return !(!otherTyped.canEqual(this));
    }

    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("RegexPatterns(");
        _result.append(")");
        return _result.toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RegexPatterns.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Pattern pattern;
        Pattern pattern2;
        Pattern pattern3;
        Pattern pattern4;
        Pattern pattern5;
        Pattern pattern6;
        Pattern pattern7;
        Pattern pattern8;
        Pattern pattern9;
        Pattern pattern10;
        Pattern pattern11;
        Pattern pattern12;
        Pattern pattern13;
        Pattern pattern14;
        Pattern pattern15;
        Pattern pattern16;
        Pattern pattern17;
        Pattern pattern18;
        Pattern pattern19;
        Pattern pattern20;
        TRUE_OR_FALSE = pattern20 = Pattern.compile("(true|false)");
        ALPHA_NUMERIC = pattern19 = Pattern.compile("[a-zA-Z0-9]+");
        ONLY_ALPHA_UNICODE = pattern18 = Pattern.compile("[\\p{L}]*");
        NUMBER = pattern17 = Pattern.compile("-?(\\d*\\.\\d+|\\d+)");
        INTEGER = pattern16 = Pattern.compile("-?(\\d+)");
        POSITIVE_INT = pattern15 = Pattern.compile("([1-9]\\d*)");
        DOUBLE = pattern14 = Pattern.compile("-?(\\d*\\.\\d+)");
        HEX = pattern13 = Pattern.compile("[a-fA-F0-9]+");
        IP_ADDRESS = pattern12 = Pattern.compile("([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])");
        HOSTNAME_PATTERN = pattern11 = Pattern.compile("((http[s]?|ftp):/)/?([^:/\\s]+)(:[0-9]{1,5})?");
        EMAIL = pattern10 = Pattern.compile("[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,6}");
        URL = pattern9 = UrlHelper.URL;
        HTTPS_URL = pattern8 = UrlHelper.HTTPS_URL;
        UUID = pattern7 = Pattern.compile("[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}");
        ANY_DATE = pattern6 = Pattern.compile("(\\d\\d\\d\\d)-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])");
        ANY_DATE_TIME = pattern5 = Pattern.compile("([0-9]{4})-(1[0-2]|0[1-9])-(3[01]|0[1-9]|[12][0-9])T(2[0-3]|[01][0-9]):([0-5][0-9]):([0-5][0-9])");
        ANY_TIME = pattern4 = Pattern.compile("(2[0-3]|[01][0-9]):([0-5][0-9]):([0-5][0-9])");
        NON_EMPTY = pattern3 = Pattern.compile("[\\S\\s]+");
        NON_BLANK = pattern2 = Pattern.compile("^\\s*\\S[\\S\\s]*");
        ISO8601_WITH_OFFSET = pattern = Pattern.compile("([0-9]{4})-(1[0-2]|0[1-9])-(3[01]|0[1-9]|[12][0-9])T(2[0-3]|[01][0-9]):([0-5][0-9]):([0-5][0-9])(\\.\\d{3})?(Z|[+-][01]\\d:[0-5]\\d)");
    }
}

