/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.camel;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.verifier.util.BodyExtractor;

class StubRunnerCamelProcessor
implements Processor {
    private final Contract groovyDsl;

    StubRunnerCamelProcessor(Contract groovyDsl) {
        this.groovyDsl = groovyDsl;
    }

    public void process(Exchange exchange) throws Exception {
        Message input = exchange.getIn();
        if (this.groovyDsl.getInput().getMessageHeaders() != null) {
            for (Header entry : this.groovyDsl.getInput().getMessageHeaders().getEntries()) {
                input.removeHeader(entry.getName());
            }
        }
        if (this.groovyDsl.getOutputMessage() == null) {
            return;
        }
        input.setBody((Object)BodyExtractor.extractStubValueFrom((Object)this.groovyDsl.getOutputMessage().getBody()));
        if (this.groovyDsl.getOutputMessage().getHeaders() != null) {
            for (Header entry : this.groovyDsl.getOutputMessage().getHeaders().getEntries()) {
                input.setHeader(entry.getName(), entry.getClientValue());
            }
        }
    }
}

