/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.camel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.toomuchcoding.jsonassert.JsonAssertion;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.BodyMatcher;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierObjectMapper;
import org.springframework.cloud.contract.verifier.util.JsonPaths;
import org.springframework.cloud.contract.verifier.util.JsonToJsonPathsConverter;
import org.springframework.cloud.contract.verifier.util.MapConverter;
import org.springframework.cloud.contract.verifier.util.MethodBufferingJsonVerifiable;

class StubRunnerCamelPredicate
implements Predicate {
    private final Contract groovyDsl;
    private final ContractVerifierObjectMapper objectMapper = new ContractVerifierObjectMapper();

    public StubRunnerCamelPredicate(Contract groovyDsl) {
        this.groovyDsl = groovyDsl;
    }

    public boolean matches(Exchange exchange) {
        DocumentContext parsedJson;
        if (!this.headersMatch(exchange)) {
            return false;
        }
        Object inputMessage = exchange.getIn().getBody();
        BodyMatchers matchers = this.groovyDsl.getInput().getMatchers();
        Object dslBody = MapConverter.getStubSideValues((Object)this.groovyDsl.getInput().getMessageBody());
        Object matchingInputMessage = JsonToJsonPathsConverter.removeMatchingJsonPaths((Object)dslBody, (BodyMatchers)matchers);
        JsonPaths jsonPaths = JsonToJsonPathsConverter.transformToJsonPathWithStubsSideValuesAndNoArraySizeCheck((Object)matchingInputMessage);
        try {
            parsedJson = JsonPath.parse((String)this.objectMapper.writeValueAsString(inputMessage));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot serialize to JSON", e);
        }
        boolean matches = true;
        for (MethodBufferingJsonVerifiable path : jsonPaths) {
            matches &= this.matchesJsonPath(parsedJson, path.jsonPath());
        }
        if (matchers != null && matchers.hasMatchers()) {
            for (BodyMatcher matcher : matchers.jsonPathMatchers()) {
                String jsonPath = JsonToJsonPathsConverter.convertJsonPathAndRegexToAJsonPath((BodyMatcher)matcher, (Object)dslBody);
                matches &= this.matchesJsonPath(parsedJson, jsonPath);
            }
        }
        return matches;
    }

    private boolean matchesJsonPath(DocumentContext parsedJson, String jsonPath) {
        try {
            JsonAssertion.assertThat((DocumentContext)parsedJson).matchesJsonPath(jsonPath);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean headersMatch(Exchange exchange) {
        Map headers = exchange.getIn().getHeaders();
        boolean matches = true;
        for (Header it : this.groovyDsl.getInput().getMessageHeaders().getEntries()) {
            String name = it.getName();
            Object value = it.getClientValue();
            Object valueInHeader = headers.get(name);
            matches &= value instanceof Pattern ? ((Pattern)value).matcher(valueInHeader.toString()).matches() : valueInHeader != null && valueInHeader.equals(value);
        }
        return matches;
    }
}

