/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.PropertyFetcher;
import org.springframework.util.StringUtils;

class StubRunnerPropertyUtils {
    private static final Log log = LogFactory.getLog(StubRunnerPropertyUtils.class);
    private static final String STUBRUNNER_PROPERTIES = "stubrunner.properties";
    static PropertyFetcher FETCHER = new PropertyFetcher();

    StubRunnerPropertyUtils() {
    }

    static boolean isPropertySet(String propName) {
        String value = StubRunnerPropertyUtils.getProperty(new HashMap<String, String>(), propName);
        return StringUtils.hasText((String)value) && Boolean.parseBoolean(value);
    }

    static boolean hasProperty(Map<String, String> options, String propName) {
        String value = StubRunnerPropertyUtils.getProperty(options, propName);
        return StringUtils.hasText((String)value);
    }

    static String getProperty(Map<String, String> options, String propName) {
        if (options != null && options.containsKey(propName)) {
            String value = options.get(propName);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Options map contains the prop [" + propName + "] with value [" + value + "]"));
            }
            return value;
        }
        return StubRunnerPropertyUtils.doGetProp(StubRunnerPropertyUtils.appendPrefixIfNecessary(propName));
    }

    private static String appendPrefixIfNecessary(String prop) {
        if (prop.toLowerCase().startsWith("stubrunner")) {
            return prop;
        }
        return "stubrunner.properties." + prop;
    }

    private static String doGetProp(String stubRunnerProp) {
        String systemProp = FETCHER.systemProp(stubRunnerProp);
        if (StringUtils.hasText((String)systemProp)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("System property [" + stubRunnerProp + "] has value [" + systemProp + "]"));
            }
            return systemProp;
        }
        String convertedEnvProp = stubRunnerProp.replaceAll("\\.", "_").replaceAll("-", "_").toUpperCase();
        String envVar = FETCHER.envVar(convertedEnvProp);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Environment variable [" + convertedEnvProp + "] has value [" + envVar + "]"));
        }
        return envVar;
    }
}

