/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;

class FileWalker
extends SimpleFileVisitor<Path> {
    private final PathMatcher matcherWithDot;
    private final PathMatcher matcherWithoutDot;
    Path foundFile;

    FileWalker(StubConfiguration stubConfiguration) {
        this.matcherWithDot = FileSystems.getDefault().getPathMatcher("glob:" + this.matcherGlob(stubConfiguration, "."));
        this.matcherWithoutDot = FileSystems.getDefault().getPathMatcher("glob:" + this.matcherGlob(stubConfiguration, "/"));
    }

    private String matcherGlob(StubConfiguration stubConfiguration, String groupArtifactSeparator) {
        return "**" + stubConfiguration.groupId + groupArtifactSeparator + stubConfiguration.artifactId + "/" + stubConfiguration.version;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.matcherWithDot.matches(dir.toAbsolutePath()) || this.matcherWithoutDot.matches(dir.toAbsolutePath())) {
            this.foundFile = dir;
            return FileVisitResult.TERMINATE;
        }
        return FileVisitResult.CONTINUE;
    }
}

