/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.integration;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.messaging.integration.StubRunnerIntegrationMessageSelector;
import org.springframework.cloud.contract.stubrunner.messaging.integration.StubRunnerIntegrationTransformer;
import org.springframework.context.Lifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.core.GenericSelector;
import org.springframework.integration.dsl.FilterEndpointSpec;
import org.springframework.integration.dsl.GenericEndpointSpec;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.transformer.GenericTransformer;
import org.springframework.integration.transformer.MessageTransformingHandler;
import org.springframework.messaging.Message;

@Configuration
@ConditionalOnClass(value={IntegrationFlowBuilder.class})
@ConditionalOnProperty(name={"stubrunner.integration.enabled"}, havingValue="true", matchIfMissing=true)
public class StubRunnerIntegrationConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"stubFlowRegistrar"})
    public FlowRegistrar stubFlowRegistrar(AutowireCapableBeanFactory beanFactory, BatchStubRunner batchStubRunner) {
        Map<StubConfiguration, Collection<Contract>> contracts = batchStubRunner.getContracts();
        for (Map.Entry<StubConfiguration, Collection<Contract>> entry : contracts.entrySet()) {
            String name = entry.getKey().getGroupId() + "_" + entry.getKey().getArtifactId();
            for (Contract dsl : entry.getValue()) {
                if (dsl.getInput() == null || dsl.getInput().getMessageFrom() == null || dsl.getInput().getMessageFrom().getClientValue() == null) continue;
                final String flowName = name + "_" + dsl.getLabel() + "_" + dsl.hashCode();
                IntegrationFlowBuilder builder = (IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((String)((String)dsl.getInput().getMessageFrom().getClientValue())).filter((GenericSelector)new StubRunnerIntegrationMessageSelector(dsl), (Consumer)new Consumer<FilterEndpointSpec>(){

                    @Override
                    public void accept(FilterEndpointSpec e) {
                        e.id(flowName + ".filter");
                    }
                })).transform((GenericTransformer)new StubRunnerIntegrationTransformer(dsl), (Consumer)new Consumer<GenericEndpointSpec<MessageTransformingHandler>>(){

                    @Override
                    public void accept(GenericEndpointSpec<MessageTransformingHandler> e) {
                        e.id(flowName + ".transformer");
                    }
                });
                builder = dsl.getOutputMessage() != null ? (IntegrationFlowBuilder)builder.channel((String)dsl.getOutputMessage().getSentTo().getClientValue()) : (IntegrationFlowBuilder)builder.handle((Object)new DummyMessageHandler(), "handle");
                beanFactory.initializeBean((Object)builder.get(), flowName);
                ((Lifecycle)beanFactory.getBean(flowName + ".filter", Lifecycle.class)).start();
                ((Lifecycle)beanFactory.getBean(flowName + ".transformer", Lifecycle.class)).start();
            }
        }
        return new FlowRegistrar();
    }

    static class FlowRegistrar {
        FlowRegistrar() {
        }
    }

    private static class DummyMessageHandler {
        private DummyMessageHandler() {
        }

        public void handle(Message<?> message) {
        }
    }
}

