/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.HttpServerStub;
import org.springframework.cloud.contract.stubrunner.ResourceResolver;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubRunner;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.provider.wiremock.WireMockHttpServerStub;
import org.springframework.cloud.contract.verifier.converter.RecursiveFilesConverter;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.SpringFactoriesLoader;

class StubRunnerFactory {
    private static final Log log = LogFactory.getLog(StubRunnerFactory.class);
    private final StubRunnerOptions stubRunnerOptions;
    private final StubDownloader stubDownloader;
    private final MessageVerifier<?> contractVerifierMessaging;

    StubRunnerFactory(StubRunnerOptions stubRunnerOptions, StubDownloader stubDownloader, MessageVerifier<?> contractVerifierMessaging) {
        this.stubRunnerOptions = stubRunnerOptions;
        this.stubDownloader = stubDownloader;
        this.contractVerifierMessaging = contractVerifierMessaging;
    }

    public Collection<StubRunner> createStubsFromServiceConfiguration() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will download stubs for dependencies " + this.stubRunnerOptions.getDependencies()));
        }
        if (this.stubRunnerOptions.getDependencies().isEmpty()) {
            log.warn((Object)"No stubs to download have been passed. Most likely you have forgotten to pass them either via annotation or a property");
        }
        ArrayList<StubRunner> result = new ArrayList<StubRunner>();
        for (StubConfiguration stubsConfiguration : this.stubRunnerOptions.getDependencies()) {
            Map.Entry<StubConfiguration, File> entry = this.stubDownloader.downloadAndUnpackStubJar(stubsConfiguration);
            if (log.isDebugEnabled()) {
                log.debug((Object)("For stub configuration [" + stubsConfiguration + "] the downloaded entry is [" + entry + "]"));
            }
            if (entry == null) continue;
            Path path = this.resolvePath(entry.getValue());
            File unpackedLocation = path.toFile();
            if (this.stubRunnerOptions.isGenerateStubs()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Flag to generate stubs at runtime was switched on. Will remove the current mappings and will generate new ones.");
                }
                this.generateMappingsAtRuntime(path);
            }
            result.add(this.createStubRunner(entry.getKey(), unpackedLocation));
        }
        return result;
    }

    private void generateMappingsAtRuntime(Path path) {
        this.removeCurrentMappings(path);
        this.generateNewMappings(path);
    }

    private Path resolvePath(File unpackedLocation) {
        Resource resource = ResourceResolver.resource(unpackedLocation.toURI().toString());
        Path path = unpackedLocation.toPath();
        if (resource != null) {
            try {
                return Paths.get(resource.getURI());
            }
            catch (IOException ex) {
                return unpackedLocation.toPath();
            }
        }
        return path;
    }

    private void removeCurrentMappings(Path path) {
        final List httpServerStubs = SpringFactoriesLoader.loadFactories(HttpServerStub.class, null);
        if (httpServerStubs.isEmpty()) {
            httpServerStubs.add(new WireMockHttpServerStub());
        }
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                private final Log log = LogFactory.getLog(StubRunnerFactory.class);

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (httpServerStubs.stream().anyMatch(h -> h.isAccepted(file.toFile()))) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Deleting file [" + file.toString() + "] since it contains a valid mapping."));
                        }
                        try {
                            Files.delete(file);
                        }
                        catch (IOException ex) {
                            this.log.warn((Object)("Failed to delete file [" + file.toString() + "]"), (Throwable)ex);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            log.warn((Object)"Exception occurred while trying to delete mappings", (Throwable)ex);
        }
    }

    private void generateNewMappings(Path path) {
        File unpackedLocation = path.toFile();
        RecursiveFilesConverter converter = new RecursiveFilesConverter(this.subfolderIfPresent(unpackedLocation, "mappings"), this.subfolderIfPresent(unpackedLocation, "contracts"), new ArrayList(), ".*", false);
        converter.processFiles();
    }

    private File subfolderIfPresent(File unpackedLocation, String subfolder) {
        File subfolderDir = new File(unpackedLocation, subfolder);
        if (subfolderDir.exists()) {
            return subfolderDir;
        }
        return unpackedLocation;
    }

    private StubRunner createStubRunner(StubConfiguration stubsConfiguration, File unzipedStubDir) {
        if (unzipedStubDir == null) {
            return null;
        }
        return this.createStubRunner(unzipedStubDir, stubsConfiguration, this.stubRunnerOptions);
    }

    private StubRunner createStubRunner(File unzippedStubsDir, StubConfiguration stubsConfiguration, StubRunnerOptions stubRunnerOptions) {
        return new StubRunner(stubRunnerOptions, unzippedStubsDir.getPath(), stubsConfiguration, this.contractVerifierMessaging);
    }
}

