/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.springframework.cloud.contract.stubrunner.ReleaseType;
import org.springframework.util.StringUtils;

class ProjectVersion
implements Comparable<ProjectVersion>,
Serializable {
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile("^.*[\\.|\\-](BUILD-)?SNAPSHOT.*$");
    private static final String MILESTONE_REGEX = ".*[\\.|\\-]M[0-9]+";
    private static final String RC_REGEX = "^.*[\\.|\\-]RC.*$";
    private static final String RELEASE_REGEX = "^.*[\\.|\\-]RELEASE.*$";
    private static final String SR_REGEX = "^.*[\\.|\\-]SR[0-9]+.*$";
    private static final List<Pattern> VALID_PATTERNS = Arrays.asList(SNAPSHOT_PATTERN, Pattern.compile(".*[\\.|\\-]M[0-9]+"), Pattern.compile("^.*[\\.|\\-]RC.*$"), Pattern.compile("^.*[\\.|\\-]RELEASE.*$"), Pattern.compile("^.*[\\.|\\-]SR[0-9]+.*$"));
    final String version;
    private final ReleaseType releaseType;

    ProjectVersion(String version) {
        this.version = version;
        this.releaseType = this.toReleaseType();
    }

    private SplitVersion assertVersion() {
        if (this.version == null) {
            throw new IllegalStateException("Version can't be null!");
        }
        SplitVersion splitByHyphen = this.tryHyphenSeparatedVersion();
        if (splitByHyphen != null) {
            return splitByHyphen;
        }
        return this.dotSeparatedReleaseTrainsAndVersions();
    }

    private SplitVersion tryHyphenSeparatedVersion() {
        String[] splitByHyphen = this.version.split("\\-");
        int splitByHyphens = splitByHyphen.length;
        int numberOfHyphens = splitByHyphens - 1;
        int indexOfFirstHyphen = this.version.indexOf("-");
        boolean buildSnapshot = this.version.endsWith("BUILD-SNAPSHOT");
        if (numberOfHyphens == 1 && !buildSnapshot || numberOfHyphens > 1 && buildSnapshot) {
            String versionName = this.version.substring(0, indexOfFirstHyphen);
            boolean hasDots = versionName.contains(".");
            String versionType = this.version.substring(indexOfFirstHyphen + 1);
            if (splitByHyphens > 1 && !hasDots && this.validVersionType()) {
                return SplitVersion.hyphen(versionName, versionType);
            }
            if (splitByHyphens == 1 && !hasDots && this.validVersionType()) {
                return SplitVersion.hyphen(splitByHyphen[0], splitByHyphen[1]);
            }
            if (splitByHyphens >= 1 && hasDots) {
                String[] newArray = this.combinedArrays(versionName, versionType);
                return SplitVersion.hyphen(newArray);
            }
            throw new UnsupportedOperationException("Unknown version [" + this.version + "]");
        }
        return null;
    }

    private boolean validVersionType() {
        return VALID_PATTERNS.stream().anyMatch(p -> p.matcher(this.version).matches());
    }

    private String[] combinedArrays(String versionName, String versionType) {
        String[] split = versionName.split("\\.");
        String[] newArray = new String[split.length + 1];
        for (int i = 0; i < split.length; ++i) {
            newArray[i] = split[i];
        }
        newArray[split.length] = versionType;
        return newArray;
    }

    private SplitVersion dotSeparatedReleaseTrainsAndVersions() {
        String[] splitVersion = this.version.split("\\.");
        return SplitVersion.dot(splitVersion);
    }

    boolean isSnapshot() {
        return this.version != null && this.version.contains("SNAPSHOT");
    }

    boolean isRc() {
        return this.version != null && this.version.matches(RC_REGEX);
    }

    boolean isMilestone() {
        return this.version != null && this.version.matches(MILESTONE_REGEX);
    }

    boolean isRelease() {
        return this.version != null && this.version.contains("RELEASE");
    }

    boolean isReleaseOrServiceRelease() {
        return this.isRelease() || this.isServiceRelease();
    }

    boolean isServiceRelease() {
        return this.version != null && this.version.matches(".*.SR[0-9]+");
    }

    private ReleaseType toReleaseType() {
        if (this.isMilestone()) {
            return ReleaseType.M;
        }
        if (this.isRc()) {
            return ReleaseType.RC;
        }
        if (this.isRelease()) {
            return ReleaseType.RELEASE;
        }
        if (this.isServiceRelease()) {
            return ReleaseType.SR;
        }
        return ReleaseType.SNAPSHOT;
    }

    int isMoreMature(ProjectVersion that) {
        boolean bothGa;
        SplitVersion thisSplit = this.assertVersion();
        SplitVersion thatSplit = that.assertVersion();
        int releaseTypeComparison = this.releaseType.compareTo(that.releaseType);
        boolean thisReleaseTypeHigher = releaseTypeComparison > 0;
        boolean bl = bothGa = this.isReleaseOrServiceRelease() && that.isReleaseOrServiceRelease();
        if (thisReleaseTypeHigher && !bothGa) {
            return 1;
        }
        int majorComparison = this.compare(thisSplit.major, thatSplit.major);
        if (majorComparison != 0) {
            return majorComparison;
        }
        int minorComparison = this.compare(thisSplit.minor, thatSplit.minor);
        if (minorComparison != 0) {
            return minorComparison;
        }
        int patchComparison = this.compare(thisSplit.patch, thatSplit.patch);
        if (patchComparison != 0) {
            return patchComparison;
        }
        return releaseTypeComparison;
    }

    private int compare(String thisString, String thatString) {
        try {
            return Integer.valueOf(thisString).compareTo(Integer.valueOf(thatString));
        }
        catch (NumberFormatException ex) {
            return thisString.compareTo(thatString);
        }
    }

    boolean isSameWithoutSuffix(ProjectVersion that) {
        SplitVersion thisSplit = this.assertVersion();
        SplitVersion thatSplit = that.assertVersion();
        return thisSplit.major.equals(thatSplit.major) && thisSplit.minor.equals(thatSplit.minor) && thisSplit.patch.equals(thatSplit.patch);
    }

    public String toString() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectVersion that = (ProjectVersion)o;
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    @Override
    public int compareTo(ProjectVersion o) {
        return this.version.compareTo(o.version);
    }

    private static final class SplitVersion {
        private static final String DOT = ".";
        private static final String HYPHEN = "-";
        final String major;
        final String minor;
        final String patch;
        final String delimiter;
        final String suffix;

        private SplitVersion(String major, String minor, String patch, String delimiter, String suffix) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.delimiter = delimiter;
            this.suffix = suffix;
            this.assertIfValid();
        }

        private SplitVersion(String major, String delimiter, String suffix) {
            this(major, "", "", delimiter, suffix);
        }

        private SplitVersion(String[] args, String delimiter) {
            this.major = SplitVersion.orDefault(args, 0);
            this.minor = SplitVersion.orDefault(args, 1);
            this.patch = SplitVersion.orDefault(args, 2);
            this.delimiter = delimiter;
            this.suffix = SplitVersion.orDefault(args, 3);
            this.assertIfValid();
        }

        private static String orDefault(String[] args, int argIndex) {
            return args.length > argIndex ? args[argIndex] : "";
        }

        static SplitVersion hyphen(String major, String suffix) {
            return new SplitVersion(major, HYPHEN, suffix);
        }

        static SplitVersion hyphen(String[] args) {
            return SplitVersion.version(args, HYPHEN);
        }

        static SplitVersion dot(String[] args) {
            return SplitVersion.version(args, DOT);
        }

        private static SplitVersion version(String[] args, String delimiter) {
            if (args.length == 2) {
                return new SplitVersion(args[0], "", "", delimiter, args[1]);
            }
            if (args.length == 3) {
                return new SplitVersion(args[0], args[1], "", delimiter, args[2]);
            }
            return new SplitVersion(args, delimiter);
        }

        private void assertIfValid() {
            if (this.isInvalid()) {
                throw new IllegalStateException("Version is invalid. Should be of format [1.2.3.A] / [1.2.3-A] or [A.B] / [A-B]");
            }
        }

        private boolean isInvalid() {
            return this.wrongReleaseTrainVersion() || this.wrongLibraryVersion() || this.wrongDelimiter() || this.noSuffix();
        }

        private boolean noSuffix() {
            return StringUtils.isEmpty((Object)this.suffix);
        }

        private String gav() {
            if (StringUtils.isEmpty((Object)this.minor)) {
                return String.format("%s", this.major);
            }
            return String.format("%s.%s.%s", this.major, this.minor, this.patch);
        }

        private boolean isNumeric(String string) {
            return string.matches("[0-9]+");
        }

        private boolean wrongDelimiter() {
            return !DOT.equals(this.delimiter) && !HYPHEN.equals(this.delimiter);
        }

        private boolean wrongLibraryVersion() {
            return this.isNumeric(this.major) && (StringUtils.isEmpty((Object)this.minor) || StringUtils.isEmpty((Object)this.patch) || StringUtils.isEmpty((Object)this.suffix) || StringUtils.isEmpty((Object)this.delimiter));
        }

        private boolean wrongReleaseTrainVersion() {
            return this.isNumeric(this.major) && StringUtils.isEmpty((Object)this.suffix);
        }
    }
}

