/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.BatchStubRunnerFactory;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilderProvider;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.stubrunner.spring.LazyMessageVerifier;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerPortBeanPostProcessor;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={StubRunnerProperties.class})
@ConditionalOnMissingBean(type={"org.springframework.cloud.contract.wiremock.WiremockServerConfiguration"})
@Import(value={StubRunnerPortBeanPostProcessor.class})
public class StubRunnerConfiguration {
    static final String STUBRUNNER_PREFIX = "stubrunner.runningstubs";
    private StubDownloaderBuilderProvider provider = new StubDownloaderBuilderProvider();
    @Autowired
    private ConfigurableEnvironment environment;

    @Bean
    public BatchStubRunner batchStubRunner(BeanFactory beanFactory) {
        StubRunnerProperties props = (StubRunnerProperties)beanFactory.getBean(StubRunnerProperties.class);
        StubRunnerOptionsBuilder builder = this.builder(props);
        if (props.getProxyHost() != null) {
            builder.withProxy(props.getProxyHost(), props.getProxyPort());
        }
        StubRunnerOptions stubRunnerOptions = this.stubRunnerOptions(builder);
        BatchStubRunner batchStubRunner = new BatchStubRunnerFactory(stubRunnerOptions, this.provider.get(stubRunnerOptions, new StubDownloaderBuilder[0]), new LazyMessageVerifier(beanFactory)).buildBatchStubRunner();
        RunningStubs runningStubs = batchStubRunner.runStubs();
        this.registerPort(runningStubs);
        return batchStubRunner;
    }

    private StubRunnerOptions stubRunnerOptions(StubRunnerOptionsBuilder builder) {
        return builder.build();
    }

    @Bean
    public BeanPostProcessor batchStubRunnerBeanPostProcessor(BatchStubRunner runner) {
        return new BeanPostProcessor(){};
    }

    private StubRunnerOptionsBuilder builder(StubRunnerProperties props) {
        return new StubRunnerOptionsBuilder().withMinMaxPort(Integer.valueOf(this.resolvePlaceholder(props.getMinPort(), props.getMinPort())), Integer.valueOf(this.resolvePlaceholder(props.getMaxPort(), props.getMaxPort()))).withStubRepositoryRoot(props.getRepositoryRoot()).withStubsMode(this.resolvePlaceholder((Object)props.getStubsMode())).withStubsClassifier(this.resolvePlaceholder(props.getClassifier())).withStubs(this.resolvePlaceholder(props.getIds())).withUsername(this.resolvePlaceholder(props.getUsername())).withPassword(this.resolvePlaceholder(props.getPassword())).withStubPerConsumer(Boolean.parseBoolean(this.resolvePlaceholder(props.isStubsPerConsumer()))).withConsumerName(this.consumerName(props)).withMappingsOutputFolder(this.resolvePlaceholder(props.getMappingsOutputFolder())).withDeleteStubsAfterTest(Boolean.parseBoolean(this.resolvePlaceholder(props.isDeleteStubsAfterTest()))).withGenerateStubs(Boolean.parseBoolean(this.resolvePlaceholder(props.isGenerateStubs()))).withProperties(props.getProperties()).withHttpServerStubConfigurer(props.getHttpServerStubConfigurer()).withServerId(this.resolvePlaceholder(props.getServerId()));
    }

    private String[] resolvePlaceholder(String[] string) {
        return (String[])Arrays.stream(string).map(this::resolvePlaceholder).toArray(String[]::new);
    }

    private String resolvePlaceholder(Object string) {
        return this.resolvePlaceholder(string, null);
    }

    private String resolvePlaceholder(Object string, Object defaultValue) {
        if (string == null) {
            return defaultValue != null ? defaultValue.toString() : null;
        }
        return this.environment.resolvePlaceholders(string.toString());
    }

    private String consumerName(StubRunnerProperties props) {
        if (StringUtils.hasText((String)props.getConsumerName())) {
            return this.resolvePlaceholder(props.getConsumerName());
        }
        return this.environment.getProperty("spring.application.name");
    }

    private void registerPort(RunningStubs runStubs) {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        if (!propertySources.contains(STUBRUNNER_PREFIX)) {
            propertySources.addFirst((PropertySource)new MapPropertySource(STUBRUNNER_PREFIX, new HashMap()));
        }
        Map source = (Map)((MapPropertySource)propertySources.get(STUBRUNNER_PREFIX)).getSource();
        for (Map.Entry<StubConfiguration, Integer> entry : runStubs.validNamesAndPorts().entrySet()) {
            source.put("stubrunner.runningstubs." + entry.getKey().getArtifactId() + ".port", entry.getValue());
            source.put("stubrunner.runningstubs." + entry.getKey().getGroupId() + "." + entry.getKey().getArtifactId() + ".port", entry.getValue());
        }
    }
}

