/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.amqp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;

class MessageListenerAccessor {
    private final RabbitListenerEndpointRegistry rabbitListenerEndpointRegistry;
    private final List<SimpleMessageListenerContainer> simpleMessageListenerContainers;
    private final List<Binding> bindings;

    MessageListenerAccessor(RabbitListenerEndpointRegistry rabbitListenerEndpointRegistry, List<SimpleMessageListenerContainer> simpleMessageListenerContainers, List<Binding> bindings) {
        this.rabbitListenerEndpointRegistry = rabbitListenerEndpointRegistry;
        this.simpleMessageListenerContainers = simpleMessageListenerContainers;
        this.bindings = bindings;
    }

    List<SimpleMessageListenerContainer> getListenerContainersForDestination(String destination) {
        List<SimpleMessageListenerContainer> listenerContainers = this.collectListenerContainers();
        Set<String> queueNames = this.collectQueuesBoundToDestination(destination);
        return this.getListenersByBoundQueues(listenerContainers, queueNames);
    }

    private List<SimpleMessageListenerContainer> getListenersByBoundQueues(List<SimpleMessageListenerContainer> listenerContainers, Set<String> queueNames) {
        ArrayList<SimpleMessageListenerContainer> matchingContainers = new ArrayList<SimpleMessageListenerContainer>();
        block0: for (SimpleMessageListenerContainer listenerContainer : listenerContainers) {
            if (listenerContainer.getQueueNames() == null) continue;
            for (String queueName : listenerContainer.getQueueNames()) {
                if (!queueNames.contains(queueName)) continue;
                matchingContainers.add(listenerContainer);
                continue block0;
            }
        }
        return matchingContainers;
    }

    private Set<String> collectQueuesBoundToDestination(String destination) {
        HashSet<String> queueNames = new HashSet<String>();
        for (Binding binding : this.bindings) {
            if (!destination.equals(binding.getExchange()) || !Binding.DestinationType.QUEUE.equals((Object)binding.getDestinationType())) continue;
            queueNames.add(binding.getDestination());
        }
        return queueNames;
    }

    private List<SimpleMessageListenerContainer> collectListenerContainers() {
        ArrayList<SimpleMessageListenerContainer> listenerContainers = new ArrayList<SimpleMessageListenerContainer>();
        if (this.simpleMessageListenerContainers != null) {
            listenerContainers.addAll(this.simpleMessageListenerContainers);
        }
        if (this.rabbitListenerEndpointRegistry != null) {
            for (MessageListenerContainer listenerContainer : this.rabbitListenerEndpointRegistry.getListenerContainers()) {
                if (!(listenerContainer instanceof SimpleMessageListenerContainer)) continue;
                listenerContainers.add((SimpleMessageListenerContainer)listenerContainer);
            }
        }
        return listenerContainers;
    }
}

