/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.amqp;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.util.concurrent.ExecutorService;
import org.mockito.Mockito;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.verifier.messaging.amqp.ContractVerifierAmqpAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={ContractVerifierAmqpAutoConfiguration.class})
@ConditionalOnProperty(value={"stubrunner.amqp.mockConnection"}, havingValue="true", matchIfMissing=true)
public class RabbitMockConnectionFactoryAutoConfiguration {
    @Bean
    public ConnectionFactory connectionFactory() {
        com.rabbitmq.client.ConnectionFactory mockConnectionFactory = (com.rabbitmq.client.ConnectionFactory)Mockito.mock(com.rabbitmq.client.ConnectionFactory.class);
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        Channel mockChannel = (Channel)Mockito.mock(Channel.class);
        try {
            Mockito.when((Object)mockConnectionFactory.newConnection((ExecutorService)null)).thenReturn((Object)mockConnection);
            Mockito.when((Object)mockConnection.isOpen()).thenReturn((Object)true);
            Mockito.when((Object)mockConnection.createChannel()).thenReturn((Object)mockChannel);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new CachingConnectionFactory(mockConnectionFactory);
    }
}

