/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.template;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import groovy.lang.Delegate;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.springframework.cloud.contract.spec.ContractTemplate;
import org.springframework.cloud.contract.spec.internal.HandlebarsContractTemplate;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.builder.TestSideRequestTemplateModel;
import org.springframework.cloud.contract.verifier.builder.handlebars.HandlebarsJsonPathHelper;
import org.springframework.cloud.contract.verifier.template.TemplateProcessor;

public class HandlebarsTemplateProcessor
implements TemplateProcessor,
ContractTemplate,
GroovyObject {
    private static final Pattern JSON_PATH_PATTERN;
    @Delegate
    private final ContractTemplate contractTemplate;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public HandlebarsTemplateProcessor() {
        MetaClass metaClass;
        HandlebarsContractTemplate handlebarsContractTemplate = new HandlebarsContractTemplate();
        this.contractTemplate = handlebarsContractTemplate;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public String transform(Request request, String testContents) {
        TestSideRequestTemplateModel templateModel = TestSideRequestTemplateModel.from(request);
        LinkedHashMap model = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{HandlebarsJsonPathHelper.REQUEST_MODEL_NAME, templateModel}), LinkedHashMap.class);
        Template bodyTemplate = this.uncheckedCompileTemplate(testContents);
        return this.templatedResponseBody(model, bodyTemplate);
    }

    @Override
    public boolean containsTemplateEntry(String line) {
        return line.matches("^.*\\{\\{\\{.*}}}.*$");
    }

    @Override
    public boolean containsJsonPathTemplateEntry(String line) {
        return line.contains(StringGroovyMethods.plus((String)this.openingTemplate(), (CharSequence)HandlebarsJsonPathHelper.NAME));
    }

    @Override
    public String jsonPathFromTemplateEntry(String line) {
        if (!this.containsJsonPathTemplateEntry(line)) {
            return "";
        }
        Matcher matcher = JSON_PATH_PATTERN.matcher(line);
        if (!matcher.matches()) {
            return "";
        }
        return matcher.group(1);
    }

    private String templatedResponseBody(Map<String, TestSideRequestTemplateModel> model, Template bodyTemplate) {
        return this.uncheckedApplyTemplate(bodyTemplate, model);
    }

    private String uncheckedApplyTemplate(Template template, Object context) {
        String string = template.apply(context);
        try {
            return string;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    private Template uncheckedCompileTemplate(String content) {
        Handlebars handlebars = new Handlebars();
        handlebars.registerHelper(HandlebarsJsonPathHelper.NAME, (Helper)new HandlebarsJsonPathHelper());
        Template template = handlebars.compileInline(content);
        try {
            return template;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    public String query(String param0, int param1) {
        return this.contractTemplate.query(param0, param1);
    }

    public String query(String param0) {
        return this.contractTemplate.query(param0);
    }

    public String header(String param0, int param1) {
        return this.contractTemplate.header(param0, param1);
    }

    public String header(String param0) {
        return this.contractTemplate.header(param0);
    }

    public String url() {
        return this.contractTemplate.url();
    }

    public String body() {
        return this.contractTemplate.body();
    }

    public String body(String param0) {
        return this.contractTemplate.body(param0);
    }

    public String closingTemplate() {
        return this.contractTemplate.closingTemplate();
    }

    public String escapedBody() {
        return this.contractTemplate.escapedBody();
    }

    public String openingTemplate() {
        return this.contractTemplate.openingTemplate();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != HandlebarsTemplateProcessor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Pattern pattern;
        JSON_PATH_PATTERN = pattern = Pattern.compile("^.*\\{\\{\\{jsonpath this '(.*)'}}}.*$");
    }
}

