/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.camel;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.camel.ContractVerifierCamelMessageBuilder;
import org.springframework.stereotype.Component;

@Component
public class CamelStubMessages
implements MessageVerifier<Message> {
    private static final Logger log = LoggerFactory.getLogger(CamelStubMessages.class);
    private final CamelContext context;
    private final ContractVerifierCamelMessageBuilder builder = new ContractVerifierCamelMessageBuilder();

    @Autowired
    public CamelStubMessages(CamelContext context) {
        this.context = context;
    }

    @Override
    public void send(Message message, String destination) {
        try {
            ProducerTemplate producerTemplate = this.context.createProducerTemplate();
            DefaultExchange exchange = new DefaultExchange(this.context);
            exchange.setIn(message);
            producerTemplate.send(destination, (Exchange)exchange);
        }
        catch (Exception e) {
            log.error("Exception occurred while trying to send a message [" + message + "] to a channel with name [" + destination + "]", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> void send(T payload, Map<String, Object> headers, String destination) {
        this.send(this.builder.create(payload, headers), destination);
    }

    @Override
    public Message receive(String destination, long timeout, TimeUnit timeUnit) {
        try {
            ConsumerTemplate consumerTemplate = this.context.createConsumerTemplate();
            Exchange exchange = consumerTemplate.receive(destination, timeUnit.toMillis(timeout));
            return exchange.getIn();
        }
        catch (Exception e) {
            log.error("Exception occurred while trying to read a message from  a channel with name [" + destination + "]", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Message receive(String destination) {
        return this.receive(destination, 5L, TimeUnit.SECONDS);
    }
}

