/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyShell;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.verifier.util.DslParseException;
import org.springframework.cloud.contract.verifier.util.NamesUtil;
import org.springframework.util.StringUtils;

public class ContractVerifierDslConverter
implements GroovyObject {
    private static final transient Log log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public ContractVerifierDslConverter() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    /*
     * Loose catch block
     */
    @Deprecated
    public static Collection<Contract> convertAsCollection(String dsl) {
        Object object = ContractVerifierDslConverter.groovyShell().evaluate(dsl);
        Collection<Contract> collection = ContractVerifierDslConverter.listOfContracts(object);
        try {
            return collection;
        }
        catch (DslParseException e) {
            throw (Throwable)e;
        }
        catch (Exception e2) {
            log.error((Object)"Exception occurred while trying to evaluate the contract", (Throwable)e2);
            throw (Throwable)new DslParseException(e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public static Collection<Contract> convertAsCollection(File rootFolder, String dsl) {
        ClassLoader classLoader = ContractVerifierDslConverter.class.getClassLoader();
        try {
            ClassLoader urlCl = ContractVerifierDslConverter.updatedClassLoader(rootFolder, classLoader);
            Object object = ContractVerifierDslConverter.groovyShell(urlCl, rootFolder).evaluate(dsl);
            Collection<Contract> collection = ContractVerifierDslConverter.listOfContracts(object);
            return collection;
        }
        catch (DslParseException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while trying to evaluate the contract", (Throwable)e);
            throw (Throwable)new DslParseException(e);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public static Collection<Contract> convertAsCollection(File dsl) {
        return ContractVerifierDslConverter.convertAsCollection(dsl.getParentFile(), dsl);
    }

    public static Collection<Contract> convertAsCollection(File rootFolder, File dsl) {
        ClassLoader classLoader = ContractVerifierDslConverter.class.getClassLoader();
        try {
            ClassLoader urlCl = ContractVerifierDslConverter.updatedClassLoader(rootFolder, classLoader);
            Object object = ContractVerifierDslConverter.groovyShell(urlCl, rootFolder).evaluate(dsl);
            Collection<Contract> collection = ContractVerifierDslConverter.listOfContracts(dsl, object);
            return collection;
        }
        catch (DslParseException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            Object v0;
            if (log.isErrorEnabled()) {
                log.error((Object)new GStringImpl(new Object[]{dsl.getPath()}, new String[]{"Exception occurred while trying to evaluate the contract at path [", "]"}), (Throwable)e);
                v0 = null;
            } else {
                v0 = null;
            }
            throw (Throwable)new DslParseException(e);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static ClassLoader updatedClassLoader(File rootFolder, ClassLoader classLoader) {
        URLClassLoader urlCl = URLClassLoader.newInstance(new URL[]{rootFolder.toURI().toURL()}, classLoader);
        Thread.currentThread().setContextClassLoader(urlCl);
        return urlCl;
    }

    private static GroovyShell groovyShell() {
        ClassLoader classLoader = ContractVerifierDslConverter.class.getClassLoader();
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        String string = "UTF-8";
        compilerConfiguration.setSourceEncoding(string);
        return new GroovyShell(classLoader, compilerConfiguration);
    }

    private static GroovyShell groovyShell(ClassLoader cl, File rootFolder) {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        String string = "UTF-8";
        compilerConfiguration.setSourceEncoding(string);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{rootFolder.getAbsolutePath()});
        compilerConfiguration.setClasspathList(list);
        return new GroovyShell(cl, compilerConfiguration);
    }

    private static Collection<Contract> listOfContracts(Object object) {
        if (object instanceof Collection) {
            return (Collection)ScriptBytecodeAdapter.asType((Object)object, Collection.class);
        }
        if (Boolean.valueOf(!DefaultTypeTransformation.booleanUnbox((Object)object)) instanceof Contract) {
            throw (Throwable)new DslParseException("Contract is not returning a Contract or list of Contracts");
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{object});
    }

    private static Collection<Contract> listOfContracts(File file, Object object) {
        if (object instanceof Collection) {
            return ContractVerifierDslConverter.withName(file, (Collection)ScriptBytecodeAdapter.asType((Object)object, Collection.class));
        }
        if (Boolean.valueOf(!DefaultTypeTransformation.booleanUnbox((Object)object)) instanceof Contract) {
            throw (Throwable)new DslParseException("Contract is not returning a Contract or list of Contracts");
        }
        return ContractVerifierDslConverter.withName(file, ScriptBytecodeAdapter.createList((Object[])new Object[]{object}));
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<Contract> withName(File file, Collection<Contract> contracts) {
        void var1_1;
        Reference file2 = new Reference((Object)file);
        Reference contracts2 = new Reference((Object)var1_1);
        Reference counter = new Reference((Object)0);
        public class _withName_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference file;
            private /* synthetic */ Reference contracts;
            private /* synthetic */ Reference counter;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _withName_closure1(Object _outerInstance, Object _thisObject, Reference file, Reference contracts, Reference counter) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.file = reference3 = file;
                this.contracts = reference2 = contracts;
                this.counter = reference = counter;
            }

            public Object doCall(Object it) {
                if (ContractVerifierDslConverter.contractNameEmpty((Contract)ScriptBytecodeAdapter.castToType((Object)it, Contract.class))) {
                    ((Contract)it).name(NamesUtil.defaultContractName((File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class), (Collection)ScriptBytecodeAdapter.castToType((Object)this.contracts.get(), Collection.class), DefaultTypeTransformation.intUnbox((Object)this.counter.get())));
                }
                Object object = this.counter.get();
                this.counter.set((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.next((Number)((Number)ScriptBytecodeAdapter.castToType((Object)this.counter.get(), Number.class))), Integer.class)));
                return it;
            }

            public File getFile() {
                return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
            }

            public Collection getContracts() {
                return (Collection)ScriptBytecodeAdapter.castToType((Object)this.contracts.get(), Collection.class);
            }

            public Integer getCounter() {
                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.counter.get(), Integer.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _withName_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.collect((Collection)((Collection)contracts2.get()), (Closure)new _withName_closure1(ContractVerifierDslConverter.class, ContractVerifierDslConverter.class, file2, contracts2, counter));
    }

    private static boolean contractNameEmpty(Contract it) {
        return it != null && StringUtils.isEmpty((Object)it.getName());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ContractVerifierDslConverter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Log log;
        ContractVerifierDslConverter.log = log = LogFactory.getLog((String)"org.springframework.cloud.contract.verifier.util.ContractVerifierDslConverter");
    }
}

