/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.Imports;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class JUnit5IgnoreImports
implements Imports {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;

    JUnit5IgnoreImports(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    @Override
    public Imports call() {
        this.blockBuilder.addLineWithEnding("import org.junit.jupiter.api.Disabled");
        return this;
    }

    @Override
    public boolean accept() {
        return this.generatedClassMetaData.configProperties.getTestFramework() == TestFramework.JUNIT5 && this.generatedClassMetaData.listOfFiles.stream().anyMatch(metadata -> metadata.isIgnored() || metadata.getConvertedContractWithMetadata().stream().anyMatch(SingleContractMetadata::isIgnored));
    }
}

