/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodVisitor;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.JaxRsAcceptor;
import org.springframework.cloud.contract.verifier.builder.JaxRsBodyParser;
import org.springframework.cloud.contract.verifier.builder.JaxRsRequestCookiesWhen;
import org.springframework.cloud.contract.verifier.builder.JaxRsRequestHeadersWhen;
import org.springframework.cloud.contract.verifier.builder.JaxRsRequestInvokerWhen;
import org.springframework.cloud.contract.verifier.builder.JaxRsRequestMethodWhen;
import org.springframework.cloud.contract.verifier.builder.JaxRsRequestWhen;
import org.springframework.cloud.contract.verifier.builder.JaxRsUrlPathWhen;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.When;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class JaxRsWhen
implements When,
BodyMethodVisitor,
JaxRsAcceptor {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final JaxRsBodyParser bodyParser;
    private final List<When> whens = new LinkedList<When>();

    JaxRsWhen(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData, JaxRsBodyParser bodyParser) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
        this.bodyParser = bodyParser;
        this.whens.addAll(Arrays.asList(new JaxRsUrlPathWhen(this.blockBuilder, this.generatedClassMetaData), new JaxRsRequestWhen(this.blockBuilder, this.generatedClassMetaData), new JaxRsRequestHeadersWhen(this.blockBuilder, bodyParser), new JaxRsRequestCookiesWhen(this.blockBuilder, bodyParser), new JaxRsRequestMethodWhen(this.blockBuilder, this.generatedClassMetaData), new JaxRsRequestInvokerWhen(this.blockBuilder)));
    }

    @Override
    public MethodVisitor<When> apply(SingleContractMetadata singleContractMetadata) {
        this.startBodyBlock(this.blockBuilder, "when:");
        this.blockBuilder.addIndented("Response response = webTarget");
        this.blockBuilder.indent();
        this.indentedBodyBlock(this.blockBuilder, this.whens, singleContractMetadata);
        this.blockBuilder.addEmptyLine().endBlock();
        if (this.expectsResponseBody(singleContractMetadata)) {
            this.blockBuilder.addLineWithEnding("String responseAsString = " + this.bodyParser.readEntity());
        }
        this.blockBuilder.endBlock();
        return this;
    }

    private boolean expectsResponseBody(SingleContractMetadata metadata) {
        return metadata.getContract().getResponse().getBody() != null;
    }

    @Override
    public boolean accept(SingleContractMetadata singleContractMetadata) {
        return this.acceptType(this.generatedClassMetaData, singleContractMetadata);
    }
}

