/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyShell;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractConverter;
import org.springframework.cloud.contract.verifier.util.DslParseException;
import org.springframework.cloud.contract.verifier.util.NamesUtil;
import org.springframework.cloud.function.compiler.java.CompilationResult;
import org.springframework.cloud.function.compiler.java.RuntimeJavaCompiler;
import org.springframework.util.StringUtils;

public class ContractVerifierDslConverter
implements ContractConverter<Collection<Contract>>,
GroovyObject {
    public static final ContractVerifierDslConverter INSTANCE;
    private static final Pattern PACKAGE_PATTERN;
    private static final Pattern CLASS_PATTERN;
    private static final RuntimeJavaCompiler COMPILER;
    private static final transient Log log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public ContractVerifierDslConverter() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    /*
     * Loose catch block
     */
    @Deprecated
    public static Collection<Contract> convertAsCollection(String dsl) {
        Object object = ContractVerifierDslConverter.groovyShell().evaluate(dsl);
        Collection<Contract> collection = ContractVerifierDslConverter.listOfContracts(object);
        try {
            return collection;
        }
        catch (DslParseException e) {
            throw (Throwable)e;
        }
        catch (Exception e2) {
            log.error((Object)"Exception occurred while trying to evaluate the contract", (Throwable)e2);
            throw (Throwable)new DslParseException(e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public static Collection<Contract> convertAsCollection(File rootFolder, String dsl) {
        ClassLoader classLoader = ContractVerifierDslConverter.class.getClassLoader();
        try {
            ClassLoader urlCl = ContractVerifierDslConverter.updatedClassLoader(rootFolder, classLoader);
            Object object = ContractVerifierDslConverter.groovyShell(urlCl, rootFolder).evaluate(dsl);
            Collection<Contract> collection = ContractVerifierDslConverter.listOfContracts(object);
            return collection;
        }
        catch (DslParseException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while trying to evaluate the contract", (Throwable)e);
            throw (Throwable)new DslParseException(e);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public static Collection<Contract> convertAsCollection(File dsl) {
        return ContractVerifierDslConverter.convertAsCollection(dsl.getParentFile(), dsl);
    }

    public static Collection<Contract> convertAsCollection(File rootFolder, File dsl) {
        ClassLoader classLoader = ContractVerifierDslConverter.class.getClassLoader();
        try {
            ClassLoader urlCl = ContractVerifierDslConverter.updatedClassLoader(rootFolder, classLoader);
            Object object = ContractVerifierDslConverter.toObject(urlCl, rootFolder, dsl);
            Collection<Contract> collection = ContractVerifierDslConverter.listOfContracts(dsl, object);
            return collection;
        }
        catch (DslParseException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            Object v0;
            if (log.isErrorEnabled()) {
                log.error((Object)new GStringImpl(new Object[]{dsl.getPath()}, new String[]{"Exception occurred while trying to evaluate the contract at path [", "]"}), (Throwable)e);
                v0 = null;
            } else {
                v0 = null;
            }
            throw (Throwable)new DslParseException(e);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static ClassLoader updatedClassLoader(File rootFolder, ClassLoader classLoader) {
        URLClassLoader urlCl = URLClassLoader.newInstance(new URL[]{rootFolder.toURI().toURL()}, classLoader);
        ContractVerifierDslConverter.updateTheThreadClassLoader(urlCl);
        return urlCl;
    }

    private static void updateTheThreadClassLoader(ClassLoader urlCl) {
        Thread.currentThread().setContextClassLoader(urlCl);
    }

    private static GroovyShell groovyShell() {
        ClassLoader classLoader = ContractVerifierDslConverter.class.getClassLoader();
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        String string = "UTF-8";
        compilerConfiguration.setSourceEncoding(string);
        return new GroovyShell(classLoader, compilerConfiguration);
    }

    private static Object toObject(ClassLoader cl, File rootFolder, File dsl) {
        if (ContractVerifierDslConverter.isJava(dsl)) {
            Object object = ContractVerifierDslConverter.parseJavaFile(cl, dsl);
            try {
                return object;
            }
            catch (Exception ex) {
                if (log.isWarnEnabled()) {
                    Object v0;
                    if (log.isWarnEnabled()) {
                        log.warn((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Exception occurred while trying to parse the file [", (Object)dsl), (CharSequence)"] as a contract. Will not parse it."), (Throwable)ex);
                        v0 = null;
                    } else {
                        v0 = null;
                    }
                }
                Object var5_5 = null;
                return var5_5;
            }
        }
        return ContractVerifierDslConverter.groovyShell(cl, rootFolder).evaluate(dsl);
    }

    private static Object parseJavaFile(ClassLoader cl, File dsl) {
        Constructor<?> constructor = ContractVerifierDslConverter.classConstructor(dsl);
        Object newInstance = constructor.newInstance(new Object[0]);
        if (Boolean.valueOf(!DefaultTypeTransformation.booleanUnbox(newInstance)) instanceof Supplier) {
            if (log.isDebugEnabled()) {
                Object v0;
                if (log.isDebugEnabled()) {
                    log.debug((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"The class [", (Object)dsl), (CharSequence)"] is not instance of Supplier. Will not parse it as a contract"));
                    v0 = null;
                } else {
                    v0 = null;
                }
            }
            return null;
        }
        Supplier supplier = (Supplier)ScriptBytecodeAdapter.castToType(newInstance, Supplier.class);
        return supplier.get();
    }

    private static Constructor<?> classConstructor(File dsl) {
        String classText = ResourceGroovyMethods.getText((File)dsl);
        Reference fqn = new Reference((Object)ContractVerifierDslConverter.fqn(classText));
        CompilationResult compilationResult = COMPILER.compile((String)fqn.get(), classText, new String[0]);
        if (!compilationResult.wasSuccessful()) {
            throw (Throwable)new IllegalStateException(StringGroovyMethods.plus((CharSequence)"Exceptions occurred while trying to compile the file ", (Object)compilationResult.getCompilationMessages()));
        }
        public final class _classConstructor_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference fqn;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _classConstructor_closure1(Object _outerInstance, Object _thisObject, Reference fqn) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.fqn = reference = fqn;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((Class)it).getName(), (Object)this.fqn.get());
            }

            @Generated
            public String getFqn() {
                return ShortTypeHandling.castToString((Object)this.fqn.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _classConstructor_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Class clazz = ShortTypeHandling.castToClass((Object)DefaultGroovyMethods.find((Collection)compilationResult.getCompiledClasses(), (Closure)new _classConstructor_closure1(ContractVerifierDslConverter.class, ContractVerifierDslConverter.class, fqn)));
        if (clazz == null) {
            throw (Throwable)new IllegalStateException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Class with name [", (CharSequence)((String)fqn.get())), (CharSequence)"] not found"));
        }
        Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return constructor;
    }

    private static boolean isJava(File dsl) {
        return dsl.getName().endsWith(".java");
    }

    private static String fqn(String classText) {
        Matcher packageMatcher = PACKAGE_PATTERN.matcher(classText);
        String fqn = "";
        if (packageMatcher.matches()) {
            String string;
            fqn = string = StringGroovyMethods.plus((String)packageMatcher.group(1), (CharSequence)".");
        }
        Matcher classMatcher = CLASS_PATTERN.matcher(classText);
        if (!classMatcher.matches()) {
            throw (Throwable)new IllegalAccessException("Can't parse the class name");
        }
        return StringGroovyMethods.plus((String)fqn, (CharSequence)classMatcher.group(1));
    }

    private static GroovyShell groovyShell(ClassLoader cl, File rootFolder) {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        String string = "UTF-8";
        compilerConfiguration.setSourceEncoding(string);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{rootFolder.getAbsolutePath()});
        compilerConfiguration.setClasspathList(list);
        return new GroovyShell(cl, compilerConfiguration);
    }

    private static Collection<Contract> listOfContracts(Object object) {
        if (object instanceof Collection) {
            return (Collection)ScriptBytecodeAdapter.asType((Object)object, Collection.class);
        }
        if (Boolean.valueOf(!DefaultTypeTransformation.booleanUnbox((Object)object)) instanceof Contract) {
            throw (Throwable)new DslParseException("Contract is not returning a Contract or list of Contracts");
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{object});
    }

    private static Collection<Contract> listOfContracts(File file, Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        if (ContractVerifierDslConverter.isACollectionOfContracts(object)) {
            return ContractVerifierDslConverter.withName(file, (Collection)ScriptBytecodeAdapter.asType((Object)object, Collection.class));
        }
        if (Boolean.valueOf(!DefaultTypeTransformation.booleanUnbox((Object)object)) instanceof Contract) {
            throw (Throwable)new DslParseException("Contract is not returning a Contract or list of Contracts");
        }
        return ContractVerifierDslConverter.withName(file, ScriptBytecodeAdapter.createList((Object[])new Object[]{object}));
    }

    private static boolean isACollectionOfContracts(Object object) {
        public final class _isACollectionOfContracts_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isACollectionOfContracts_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return it instanceof Contract;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isACollectionOfContracts_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return object instanceof Collection && DefaultGroovyMethods.every((Iterable)((Collection)ScriptBytecodeAdapter.castToType((Object)object, Collection.class)), (Closure)new _isACollectionOfContracts_closure2(ContractVerifierDslConverter.class, ContractVerifierDslConverter.class));
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<Contract> withName(File file, Collection<Contract> contracts) {
        void var1_1;
        Reference file2 = new Reference((Object)file);
        Reference contracts2 = new Reference((Object)var1_1);
        Reference counter = new Reference((Object)0);
        public final class _withName_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference file;
            private /* synthetic */ Reference contracts;
            private /* synthetic */ Reference counter;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _withName_closure3(Object _outerInstance, Object _thisObject, Reference file, Reference contracts, Reference counter) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.file = reference3 = file;
                this.contracts = reference2 = contracts;
                this.counter = reference = counter;
            }

            public Object doCall(Object it) {
                if (ContractVerifierDslConverter.contractNameEmpty((Contract)ScriptBytecodeAdapter.castToType((Object)it, Contract.class))) {
                    ((Contract)it).name(NamesUtil.defaultContractName((File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class), (Collection)ScriptBytecodeAdapter.castToType((Object)this.contracts.get(), Collection.class), DefaultTypeTransformation.intUnbox((Object)this.counter.get())));
                }
                Object object = this.counter.get();
                this.counter.set((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.next((Number)((Number)ScriptBytecodeAdapter.castToType((Object)this.counter.get(), Number.class))), Integer.class)));
                return it;
            }

            @Generated
            public File getFile() {
                return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
            }

            @Generated
            public Collection getContracts() {
                return (Collection)ScriptBytecodeAdapter.castToType((Object)this.contracts.get(), Collection.class);
            }

            @Generated
            public Integer getCounter() {
                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.counter.get(), Integer.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _withName_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.collect((Iterable)((Collection)contracts2.get()), (Closure)new _withName_closure3(ContractVerifierDslConverter.class, ContractVerifierDslConverter.class, file2, contracts2, counter));
    }

    private static boolean contractNameEmpty(Contract it) {
        return it != null && StringUtils.isEmpty((Object)it.getName());
    }

    public boolean isAccepted(File file) {
        return file.getName().endsWith(".groovy") || file.getName().endsWith(".gvy") || file.getName().endsWith(".java");
    }

    public Collection<Contract> convertFrom(File file) {
        return ContractVerifierDslConverter.convertAsCollection(file);
    }

    public Collection<Contract> convertTo(Collection<Contract> contract) {
        return contract;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ContractVerifierDslConverter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Log log;
        RuntimeJavaCompiler runtimeJavaCompiler;
        Pattern pattern;
        Pattern pattern2;
        ContractVerifierDslConverter contractVerifierDslConverter;
        INSTANCE = contractVerifierDslConverter = new ContractVerifierDslConverter();
        PACKAGE_PATTERN = pattern2 = Pattern.compile(".*package (.+?);.+?", Pattern.DOTALL);
        CLASS_PATTERN = pattern = Pattern.compile(".+?class (.+?)( |\\{).+?", Pattern.DOTALL);
        COMPILER = runtimeJavaCompiler = new RuntimeJavaCompiler();
        ContractVerifierDslConverter.log = log = LogFactory.getLog((String)"org.springframework.cloud.contract.verifier.util.ContractVerifierDslConverter");
    }
}

