/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.cloud.contract.spec.ContractVerifierException;
import org.springframework.cloud.contract.verifier.FileSaver;
import org.springframework.cloud.contract.verifier.builder.JavaTestGenerator;
import org.springframework.cloud.contract.verifier.builder.SingleTestGenerator;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.file.ContractFileScanner;
import org.springframework.cloud.contract.verifier.file.ContractFileScannerBuilder;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.util.NamesUtil;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class TestGenerator
implements GroovyObject {
    private static final String DEFAULT_CLASS_PREFIX = "ContractVerifier";
    private static final String DEFAULT_TEST_PACKAGE = "org.springframework.cloud.contract.verifier.tests";
    private static final Log log;
    private final ContractVerifierConfigProperties configProperties;
    private AtomicInteger counter;
    private SingleTestGenerator generator;
    private FileSaver saver;
    private ContractFileScanner contractFileScanner;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public TestGenerator(ContractVerifierConfigProperties configProperties) {
        this(configProperties, TestGenerator.singleTestGenerator(), new FileSaver(configProperties.getGeneratedTestSourcesDir(), configProperties.getTestFramework().getClassExtension(), TestGenerator.singleTestGenerator()));
    }

    public TestGenerator(ContractVerifierConfigProperties configProperties, SingleTestGenerator generator, FileSaver saver) {
        ContractFileScanner contractFileScanner;
        FileSaver fileSaver;
        SingleTestGenerator singleTestGenerator;
        ContractVerifierConfigProperties contractVerifierConfigProperties;
        MetaClass metaClass;
        AtomicInteger atomicInteger;
        this.counter = atomicInteger = new AtomicInteger();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.configProperties = contractVerifierConfigProperties = configProperties;
        if (configProperties.getContractsDslDir() == null) {
            throw (Throwable)new ContractVerifierException(StringGroovyMethods.plus((CharSequence)"Stubs directory not found under ", (Object)configProperties.getContractsDslDir()));
        }
        this.generator = singleTestGenerator = generator;
        this.saver = fileSaver = saver;
        this.contractFileScanner = contractFileScanner = new ContractFileScannerBuilder().baseDir(configProperties.getContractsDslDir()).excluded((Set)ScriptBytecodeAdapter.asType(configProperties.getExcludedFiles(), Set.class)).ignored((Set)ScriptBytecodeAdapter.asType(configProperties.getIgnoredFiles(), Set.class)).included((Set)ScriptBytecodeAdapter.asType(configProperties.getIncludedFiles(), Set.class)).includeMatcher(this.configProperties.getIncludedContracts()).build();
    }

    protected TestGenerator(ContractVerifierConfigProperties configProperties, SingleTestGenerator generator, FileSaver saver, ContractFileScanner contractFileScanner) {
        ContractFileScanner contractFileScanner2;
        FileSaver fileSaver;
        SingleTestGenerator singleTestGenerator;
        ContractVerifierConfigProperties contractVerifierConfigProperties;
        MetaClass metaClass;
        AtomicInteger atomicInteger;
        this.counter = atomicInteger = new AtomicInteger();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.configProperties = contractVerifierConfigProperties = configProperties;
        if (configProperties.getContractsDslDir() == null) {
            throw (Throwable)new ContractVerifierException(StringGroovyMethods.plus((CharSequence)"Stubs directory not found under ", (Object)configProperties.getContractsDslDir()));
        }
        this.generator = singleTestGenerator = generator;
        this.saver = fileSaver = saver;
        this.contractFileScanner = contractFileScanner2 = contractFileScanner;
    }

    private static SingleTestGenerator singleTestGenerator() {
        List factories = SpringFactoriesLoader.loadFactories(SingleTestGenerator.class, null);
        if (factories.isEmpty()) {
            return new JavaTestGenerator();
        }
        return (SingleTestGenerator)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.first((List)factories), SingleTestGenerator.class);
    }

    public int generate() {
        this.generateTestClasses(this.basePackageName());
        NamesUtil.recrusiveDirectoryToPackage(this.configProperties.getGeneratedTestSourcesDir());
        NamesUtil.recrusiveDirectoryToPackage(this.configProperties.getGeneratedTestResourcesDir());
        return this.counter.get();
    }

    private String basePackageName() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.configProperties.getBasePackageForTests())) {
            return this.configProperties.getBasePackageForTests();
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.configProperties.getBaseClassForTests())) {
            return NamesUtil.toLastDot(this.configProperties.getBaseClassForTests());
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.configProperties.getPackageWithBaseClasses())) {
            return this.configProperties.getPackageWithBaseClasses();
        }
        return DEFAULT_TEST_PACKAGE;
    }

    void generateTestClasses(String basePackageName) {
        MultiValueMap<Path, ContractMetadata> contracts = this.contractFileScanner.findContractsRecursively();
        if (log.isDebugEnabled()) {
            log.debug((Object)StringGroovyMethods.plus((CharSequence)"Found the following contracts ", contracts.keySet()));
        }
        Set<Map.Entry<Path, List<ContractMetadata>>> inProgress = this.inProgress(contracts);
        if (!inProgress.isEmpty() && this.configProperties.isFailOnInProgress()) {
            public final class _generateTestClasses_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _generateTestClasses_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((Path)((Map.Entry)it).getKey()).toString();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _generateTestClasses_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            throw (Throwable)new IllegalStateException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"In progress contracts found in paths [", (CharSequence)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect(inProgress, (Closure)new _generateTestClasses_closure1(this, this)), (String)",")), (CharSequence)"] and the switch [failOnInProgress] is set to [true]. Either unmark those contracts as in progress, or set the switch to [false]."));
        }
        this.processAllNotInProgress(contracts, basePackageName);
    }

    private Set<Map.Entry<Path, List<ContractMetadata>>> inProgress(MultiValueMap<Path, ContractMetadata> contracts) {
        CallSite[] callSiteArray = TestGenerator.$getCallSiteArray();
        public final class _inProgress_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _inProgress_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _inProgress_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map.Entry<Path, List<ContractMetadata>> entry) {
                CallSite[] callSiteArray = _inProgress_closure2.$getCallSiteArray();
                public final class _closure5
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure5(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        return callSiteArray[0].call(it);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "anyInProgress";
                        return new CallSiteArray(_closure5.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure5.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call(callSiteArray[1].call(entry), (Object)new _closure5((Object)this, this.getThisObject()));
            }

            public Object call(Map.Entry<Path, List<ContractMetadata>> entry) {
                CallSite[] callSiteArray = _inProgress_closure2.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, entry);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _inProgress_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "any";
                stringArray[1] = "getValue";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _inProgress_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_inProgress_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _inProgress_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].call(contracts), (Object)new _inProgress_closure2(this, this)), Set.class);
    }

    Set<Map.Entry<Path, List<ContractMetadata>>> processAllNotInProgress(MultiValueMap<Path, ContractMetadata> contracts, String basePackageName) {
        Reference basePackageName2 = new Reference((Object)basePackageName);
        CallSite[] callSiteArray = TestGenerator.$getCallSiteArray();
        public final class _processAllNotInProgress_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _processAllNotInProgress_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _processAllNotInProgress_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map.Entry<Path, List<ContractMetadata>> entry) {
                CallSite[] callSiteArray = _processAllNotInProgress_closure3.$getCallSiteArray();
                public final class _closure6
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure6(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                        return callSiteArray[0].call(it);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "anyInProgress";
                        return new CallSiteArray(_closure6.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure6.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(entry), (Object)new _closure6((Object)this, this.getThisObject())));
            }

            public Object call(Map.Entry<Path, List<ContractMetadata>> entry) {
                CallSite[] callSiteArray = _processAllNotInProgress_closure3.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, entry);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processAllNotInProgress_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "any";
                stringArray[1] = "value";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _processAllNotInProgress_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_processAllNotInProgress_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _processAllNotInProgress_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _processAllNotInProgress_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference basePackageName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _processAllNotInProgress_closure4(Object _outerInstance, Object _thisObject, Reference basePackageName) {
                Reference reference;
                CallSite[] callSiteArray = _processAllNotInProgress_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.basePackageName = reference = basePackageName;
            }

            public Object doCall(Map.Entry<Path, List<ContractMetadata>> entry) {
                CallSite[] callSiteArray = _processAllNotInProgress_closure4.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].callCurrent((GroovyObject)this, entry), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(entry), Collection.class)), Collection.class), this.basePackageName.get());
            }

            public Object call(Map.Entry<Path, List<ContractMetadata>> entry) {
                CallSite[] callSiteArray = _processAllNotInProgress_closure4.$getCallSiteArray();
                return callSiteArray[3].callCurrent((GroovyObject)this, entry);
            }

            @Generated
            public String getBasePackageName() {
                CallSite[] callSiteArray = _processAllNotInProgress_closure4.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.basePackageName.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processAllNotInProgress_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "processIncludedDirectory";
                stringArray[1] = "relativizeContractPath";
                stringArray[2] = "getValue";
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _processAllNotInProgress_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_processAllNotInProgress_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _processAllNotInProgress_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(contracts), (Object)new _processAllNotInProgress_closure3(this, this)), (Object)new _processAllNotInProgress_closure4(this, this, basePackageName2)), Set.class);
    }

    private String relativizeContractPath(Map.Entry<Path, List<ContractMetadata>> entry) {
        Path relativePath = this.configProperties.getContractsDslDir().toPath().relativize((Path)ScriptBytecodeAdapter.castToType((Object)entry.getKey(), Path.class));
        if (StringUtils.isEmpty((Object)relativePath.toString())) {
            return DEFAULT_CLASS_PREFIX;
        }
        return relativePath.toString();
    }

    private void processIncludedDirectory(String includedDirectoryRelativePath, Collection<ContractMetadata> contracts, String basePackageNameForClass) {
        if (log.isDebugEnabled()) {
            log.debug((Object)new GStringImpl(new Object[]{contracts, includedDirectoryRelativePath}, new String[]{"Collected contracts with metadata ", " relative path is [", "]"}));
        }
        if (contracts.size() != 0) {
            String className = StringGroovyMethods.plus((String)NamesUtil.afterLast(includedDirectoryRelativePath.toString(), File.separator), (CharSequence)this.resolveNameSuffix());
            String convertedClassName = NamesUtil.convertIllegalPackageChars(className);
            String packageName = TestGenerator.buildPackage(basePackageNameForClass, includedDirectoryRelativePath);
            Path dir = this.saver.generateTestBaseDir(basePackageNameForClass, NamesUtil.convertIllegalPackageChars(includedDirectoryRelativePath.toString()));
            Path classPath = this.saver.pathToClass(dir, convertedClassName);
            byte[] classBytes = this.generator.buildClass(this.configProperties, contracts, includedDirectoryRelativePath, new SingleTestGenerator.GeneratedClassData(convertedClassName, packageName, classPath)).getBytes(StandardCharsets.UTF_8);
            this.saver.saveClassFile(classPath, classBytes);
            this.counter.incrementAndGet();
        }
    }

    private String resolveNameSuffix() {
        String string = this.configProperties.getNameSuffixForTests();
        return DefaultTypeTransformation.booleanUnbox((Object)string) ? string : this.configProperties.getTestFramework().getClassNameSuffix();
    }

    protected static String buildPackage(String packageNameForClass, String includedDirectoryRelativePath) {
        String directory = NamesUtil.beforeLast(includedDirectoryRelativePath, File.separator);
        String convertedPackage = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{packageNameForClass, NamesUtil.directoryToPackage(NamesUtil.convertIllegalPackageChars(directory))}, new String[]{"", ".", ""}));
        return !directory.isEmpty() ? convertedPackage : packageNameForClass;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TestGenerator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Log log;
        TestGenerator.log = log = LogFactory.getLog(TestGenerator.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "findAll";
        stringArray[1] = "entrySet";
        stringArray[2] = "each";
        stringArray[3] = "findAll";
        stringArray[4] = "entrySet";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[5];
        TestGenerator.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(TestGenerator.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = TestGenerator.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

