/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.stream;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpContractVerifierAutoConfiguration;
import org.springframework.cloud.contract.verifier.messaging.stream.ContractVerifierHelper;
import org.springframework.cloud.contract.verifier.messaging.stream.DestinationResolver;
import org.springframework.cloud.contract.verifier.messaging.stream.StreamFromBinderMappingMessageSender;
import org.springframework.cloud.contract.verifier.messaging.stream.StreamInputDestinationMessageSender;
import org.springframework.cloud.contract.verifier.messaging.stream.StreamMessageCollectorMessageReceiver;
import org.springframework.cloud.contract.verifier.messaging.stream.StreamOutputDestinationMessageReceiver;
import org.springframework.cloud.contract.verifier.messaging.stream.StreamPollableChannelMessageReceiver;
import org.springframework.cloud.contract.verifier.messaging.stream.StreamStubMessageSender;
import org.springframework.cloud.contract.verifier.messaging.stream.StreamStubMessages;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.binder.test.InputDestination;
import org.springframework.cloud.stream.test.binder.MessageCollector;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.Message;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={EnableBinding.class})
@ConditionalOnProperty(name={"stubrunner.stream.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={NoOpContractVerifierAutoConfiguration.class})
public class ContractVerifierStreamAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ContractVerifierMessaging<?> contractVerifierMessagingConverter(MessageVerifier<Message<?>> exchange) {
        return new ContractVerifierHelper(exchange);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.cloud.stream.test.binder.MessageCollector", "org.springframework.cloud.stream.binder.test.InputDestination"})
    static class NoMessageCollectorClassConfiguration {
        NoMessageCollectorClassConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        MessageVerifier<Message<?>> contractVerifierMessageExchangeWithNoMessageCollector(ApplicationContext applicationContext) {
            return new StreamStubMessages(new StreamStubMessageSender(applicationContext), new StreamPollableChannelMessageReceiver(applicationContext));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MessageCollector.class})
    static class MessageCollectorConfiguration {
        MessageCollectorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        MessageVerifier<Message<?>> contractVerifierMessageExchangeWithMessageCollector(ApplicationContext context) {
            DestinationResolver resolver = new DestinationResolver(context);
            return new StreamStubMessages(new StreamFromBinderMappingMessageSender(context, resolver), new StreamMessageCollectorMessageReceiver(resolver, context));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={InputDestination.class})
    @ConditionalOnMissingClass(value={"org.springframework.cloud.stream.test.binder.MessageCollector"})
    static class InputDestinationConfiguration {
        InputDestinationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        MessageVerifier<Message<?>> contractVerifierMessageExchangeWithDestinations(ApplicationContext context) {
            return new StreamStubMessages(new StreamInputDestinationMessageSender(context), new StreamOutputDestinationMessageReceiver(context));
        }
    }
}

