/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class YamlContract {
    public Request request;
    public Response response;
    public Input input;
    public OutputMessage outputMessage;
    public String description;
    public String label;
    public String name;
    public Integer priority;
    public boolean ignored;
    public boolean inProgress;

    public static class OutputMessage {
        public String sentTo;
        public Map<String, Object> headers = new LinkedHashMap<String, Object>();
        public Object body;
        public String bodyFromFile;
        public String bodyFromFileAsBytes;
        public String assertThat;
        public TestMatchers matchers = new TestMatchers();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutputMessage that = (OutputMessage)o;
            return Objects.equals(this.sentTo, that.sentTo) && Objects.equals(this.headers, that.headers) && Objects.equals(this.body, that.body) && Objects.equals(this.bodyFromFile, that.bodyFromFile) && Objects.equals(this.bodyFromFileAsBytes, that.bodyFromFileAsBytes) && Objects.equals(this.assertThat, that.assertThat) && Objects.equals(this.matchers, that.matchers);
        }

        public int hashCode() {
            return Objects.hash(this.sentTo, this.headers, this.body, this.bodyFromFile, this.bodyFromFileAsBytes, this.assertThat, this.matchers);
        }

        public String toString() {
            return "OutputMessage{sentTo='" + this.sentTo + '\'' + ", headers=" + this.headers + ", body=" + this.body + ", bodyFromFile='" + this.bodyFromFile + '\'' + ", bodyFromFileAsBytes='" + this.bodyFromFileAsBytes + '\'' + ", assertThat='" + this.assertThat + '\'' + ", matchers=" + this.matchers + '}';
        }
    }

    public static class Input {
        public String messageFrom;
        public String triggeredBy;
        public Map<String, Object> messageHeaders = new LinkedHashMap<String, Object>();
        public Object messageBody;
        public String messageBodyFromFile;
        public String messageBodyFromFileAsBytes;
        public String assertThat;
        public StubMatchers matchers = new StubMatchers();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Input input = (Input)o;
            return Objects.equals(this.messageFrom, input.messageFrom) && Objects.equals(this.triggeredBy, input.triggeredBy) && Objects.equals(this.messageHeaders, input.messageHeaders) && Objects.equals(this.messageBody, input.messageBody) && Objects.equals(this.messageBodyFromFile, input.messageBodyFromFile) && Objects.equals(this.messageBodyFromFileAsBytes, input.messageBodyFromFileAsBytes) && Objects.equals(this.assertThat, input.assertThat) && Objects.equals(this.matchers, input.matchers);
        }

        public int hashCode() {
            return Objects.hash(this.messageFrom, this.triggeredBy, this.messageHeaders, this.messageBody, this.messageBodyFromFile, this.messageBodyFromFileAsBytes, this.assertThat, this.matchers);
        }

        public String toString() {
            return "Input{messageFrom='" + this.messageFrom + '\'' + ", triggeredBy='" + this.triggeredBy + '\'' + ", messageHeaders=" + this.messageHeaders + ", messageBody=" + this.messageBody + ", messageBodyFromFile='" + this.messageBodyFromFile + '\'' + ", messageBodyFromFileAsBytes='" + this.messageBodyFromFileAsBytes + '\'' + ", assertThat='" + this.assertThat + '\'' + ", matchers=" + this.matchers + '}';
        }
    }

    public static class TestMatchers {
        public List<BodyTestMatcher> body = new ArrayList<BodyTestMatcher>();
        public List<TestHeaderMatcher> headers = new ArrayList<TestHeaderMatcher>();
        public List<TestCookieMatcher> cookies = new ArrayList<TestCookieMatcher>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestMatchers that = (TestMatchers)o;
            return Objects.equals(this.body, that.body) && Objects.equals(this.headers, that.headers) && Objects.equals(this.cookies, that.cookies);
        }

        public int hashCode() {
            return Objects.hash(this.body, this.headers, this.cookies);
        }

        public String toString() {
            return "TestMatchers{body=" + this.body + ", headers=" + this.headers + ", cookies=" + this.cookies + '}';
        }
    }

    public static class Response {
        public int status;
        public Map<String, Object> headers = new LinkedHashMap<String, Object>();
        public Map<String, Object> cookies = new LinkedHashMap<String, Object>();
        public Object body;
        public String bodyFromFile;
        public String bodyFromFileAsBytes;
        public TestMatchers matchers = new TestMatchers();
        public Boolean async;
        public Integer fixedDelayMilliseconds;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.status == response.status && Objects.equals(this.headers, response.headers) && Objects.equals(this.cookies, response.cookies) && Objects.equals(this.body, response.body) && Objects.equals(this.bodyFromFile, response.bodyFromFile) && Objects.equals(this.bodyFromFileAsBytes, response.bodyFromFileAsBytes) && Objects.equals(this.matchers, response.matchers) && Objects.equals(this.async, response.async) && Objects.equals(this.fixedDelayMilliseconds, response.fixedDelayMilliseconds);
        }

        public int hashCode() {
            return Objects.hash(this.status, this.headers, this.cookies, this.body, this.bodyFromFile, this.bodyFromFileAsBytes, this.matchers, this.async, this.fixedDelayMilliseconds);
        }

        public String toString() {
            return "Response{status=" + this.status + ", headers=" + this.headers + ", cookies=" + this.cookies + ", body=" + this.body + ", bodyFromFile='" + this.bodyFromFile + '\'' + ", bodyFromFileAsBytes='" + this.bodyFromFileAsBytes + '\'' + ", matchers=" + this.matchers + ", async=" + this.async + ", fixedDelayMilliseconds=" + this.fixedDelayMilliseconds + '}';
        }
    }

    public static enum TestMatcherType {
        by_date,
        by_time,
        by_timestamp,
        by_regex,
        by_equality,
        by_type,
        by_command,
        by_null;

    }

    public static enum StubMatcherType {
        by_date,
        by_time,
        by_timestamp,
        by_regex,
        by_equality,
        by_type,
        by_null;

    }

    public static enum PredefinedRegex {
        only_alpha_unicode,
        number,
        any_double,
        any_boolean,
        ip_address,
        hostname,
        email,
        url,
        uuid,
        iso_date,
        iso_date_time,
        iso_time,
        iso_8601_with_offset,
        non_empty,
        non_blank;

    }

    public static class TestCookieMatcher {
        public String key;
        public String regex;
        public String command;
        public PredefinedRegex predefined;
        public RegexType regexType;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestCookieMatcher that = (TestCookieMatcher)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.regex, that.regex) && Objects.equals(this.command, that.command) && this.predefined == that.predefined && this.regexType == that.regexType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.key, this.regex, this.command, this.predefined, this.regexType});
        }

        public String toString() {
            return "TestCookieMatcher{key='" + this.key + '\'' + ", regex='" + this.regex + '\'' + ", command='" + this.command + '\'' + ", predefined=" + (Object)((Object)this.predefined) + ", regexType=" + (Object)((Object)this.regexType) + '}';
        }
    }

    public static class TestHeaderMatcher {
        public String key;
        public String regex;
        public String command;
        public PredefinedRegex predefined;
        public RegexType regexType;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestHeaderMatcher that = (TestHeaderMatcher)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.regex, that.regex) && Objects.equals(this.command, that.command) && this.predefined == that.predefined && this.regexType == that.regexType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.key, this.regex, this.command, this.predefined, this.regexType});
        }

        public String toString() {
            return "TestHeaderMatcher{key='" + this.key + '\'' + ", regex='" + this.regex + '\'' + ", command='" + this.command + '\'' + ", predefined=" + (Object)((Object)this.predefined) + ", regexType=" + (Object)((Object)this.regexType) + '}';
        }
    }

    public static class QueryParameterMatcher {
        public String key;
        public MatchingType type;
        public Object value;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryParameterMatcher that = (QueryParameterMatcher)o;
            return Objects.equals(this.key, that.key) && this.type == that.type && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.key, this.type, this.value});
        }

        public String toString() {
            return "QueryParameterMatcher{key='" + this.key + '\'' + ", type=" + (Object)((Object)this.type) + ", value=" + this.value + '}';
        }
    }

    public static class HeadersMatcher
    extends KeyValueMatcher {
    }

    public static class KeyValueMatcher {
        public String key;
        public String regex;
        public PredefinedRegex predefined;
        public String command;
        public RegexType regexType;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyValueMatcher that = (KeyValueMatcher)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.regex, that.regex) && this.predefined == that.predefined && Objects.equals(this.command, that.command) && this.regexType == that.regexType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.key, this.regex, this.predefined, this.command, this.regexType});
        }

        public String toString() {
            return "KeyValueMatcher{key='" + this.key + '\'' + ", regex='" + this.regex + '\'' + ", predefined=" + (Object)((Object)this.predefined) + ", command='" + this.command + '\'' + ", regexType=" + (Object)((Object)this.regexType) + '}';
        }
    }

    public static class BodyTestMatcher {
        public String path;
        public TestMatcherType type;
        public String value;
        public Integer minOccurrence;
        public Integer maxOccurrence;
        public PredefinedRegex predefined;
        public RegexType regexType;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BodyTestMatcher that = (BodyTestMatcher)o;
            return Objects.equals(this.path, that.path) && this.type == that.type && Objects.equals(this.value, that.value) && Objects.equals(this.minOccurrence, that.minOccurrence) && Objects.equals(this.maxOccurrence, that.maxOccurrence) && this.predefined == that.predefined && this.regexType == that.regexType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.path, this.type, this.value, this.minOccurrence, this.maxOccurrence, this.predefined, this.regexType});
        }

        public String toString() {
            return "BodyTestMatcher{path='" + this.path + '\'' + ", type=" + (Object)((Object)this.type) + ", value='" + this.value + '\'' + ", minOccurrence=" + this.minOccurrence + ", maxOccurrence=" + this.maxOccurrence + ", predefined=" + (Object)((Object)this.predefined) + ", regexType=" + (Object)((Object)this.regexType) + '}';
        }
    }

    public static class ValueMatcher {
        public String regex;
        public PredefinedRegex predefined;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueMatcher that = (ValueMatcher)o;
            return Objects.equals(this.regex, that.regex) && this.predefined == that.predefined;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.regex, this.predefined});
        }

        public String toString() {
            return "ValueMatcher{regex='" + this.regex + '\'' + ", predefined=" + (Object)((Object)this.predefined) + '}';
        }
    }

    public static class MultipartNamedStubMatcher {
        public String paramName;
        public ValueMatcher fileName;
        public ValueMatcher fileContent;
        public ValueMatcher contentType;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultipartNamedStubMatcher that = (MultipartNamedStubMatcher)o;
            return Objects.equals(this.paramName, that.paramName) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.fileContent, that.fileContent) && Objects.equals(this.contentType, that.contentType);
        }

        public int hashCode() {
            return Objects.hash(this.paramName, this.fileName, this.fileContent, this.contentType);
        }

        public String toString() {
            return "MultipartNamedStubMatcher{paramName='" + this.paramName + '\'' + ", fileName=" + this.fileName + ", fileContent=" + this.fileContent + ", contentType=" + this.contentType + '}';
        }
    }

    public static class MultipartStubMatcher {
        public List<KeyValueMatcher> params = new ArrayList<KeyValueMatcher>();
        public List<MultipartNamedStubMatcher> named = new ArrayList<MultipartNamedStubMatcher>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultipartStubMatcher that = (MultipartStubMatcher)o;
            return Objects.equals(this.params, that.params) && Objects.equals(this.named, that.named);
        }

        public int hashCode() {
            return Objects.hash(this.params, this.named);
        }

        public String toString() {
            return "MultipartStubMatcher{params=" + this.params + ", named=" + this.named + '}';
        }
    }

    public static enum RegexType {
        as_integer,
        as_double,
        as_float,
        as_long,
        as_short,
        as_boolean,
        as_string;

    }

    public static class BodyStubMatcher {
        public String path;
        public StubMatcherType type;
        public String value;
        public PredefinedRegex predefined;
        public Integer minOccurrence;
        public Integer maxOccurrence;
        public RegexType regexType;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BodyStubMatcher that = (BodyStubMatcher)o;
            return Objects.equals(this.path, that.path) && this.type == that.type && Objects.equals(this.value, that.value) && this.predefined == that.predefined && Objects.equals(this.minOccurrence, that.minOccurrence) && Objects.equals(this.maxOccurrence, that.maxOccurrence) && this.regexType == that.regexType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.path, this.type, this.value, this.predefined, this.minOccurrence, this.maxOccurrence, this.regexType});
        }

        public String toString() {
            return "BodyStubMatcher{path='" + this.path + '\'' + ", type=" + (Object)((Object)this.type) + ", value='" + this.value + '\'' + ", predefined=" + (Object)((Object)this.predefined) + ", minOccurrence=" + this.minOccurrence + ", maxOccurrence=" + this.maxOccurrence + ", regexType=" + (Object)((Object)this.regexType) + '}';
        }
    }

    public static enum MatchingType {
        equal_to,
        containing,
        matching,
        not_matching,
        equal_to_json,
        equal_to_xml,
        absent,
        binary_equal_to;


        static MatchingType from(String string) {
            return Arrays.stream(MatchingType.values()).filter(matchingType -> matchingType.name().replace("_", "").equalsIgnoreCase(string.toLowerCase().replace("_", ""))).findFirst().orElse(null);
        }
    }

    public static class StubMatchers {
        public KeyValueMatcher url;
        public List<BodyStubMatcher> body = new ArrayList<BodyStubMatcher>();
        public List<KeyValueMatcher> headers = new ArrayList<KeyValueMatcher>();
        public List<QueryParameterMatcher> queryParameters = new ArrayList<QueryParameterMatcher>();
        public List<KeyValueMatcher> cookies = new ArrayList<KeyValueMatcher>();
        public MultipartStubMatcher multipart;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StubMatchers that = (StubMatchers)o;
            return Objects.equals(this.url, that.url) && Objects.equals(this.body, that.body) && Objects.equals(this.headers, that.headers) && Objects.equals(this.queryParameters, that.queryParameters) && Objects.equals(this.cookies, that.cookies) && Objects.equals(this.multipart, that.multipart);
        }

        public int hashCode() {
            return Objects.hash(this.url, this.body, this.headers, this.queryParameters, this.cookies, this.multipart);
        }

        public String toString() {
            return "StubMatchers{url=" + this.url + ", body=" + this.body + ", headers=" + this.headers + ", queryParameters=" + this.queryParameters + ", cookies=" + this.cookies + ", multipart=" + this.multipart + '}';
        }
    }

    public static class Named {
        public String paramName;
        public String fileName;
        public String fileContent;
        public String fileContentAsBytes;
        public String fileContentFromFileAsBytes;
        public String contentType;
        public String fileNameCommand;
        public String fileContentCommand;
        public String contentTypeCommand;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Named named = (Named)o;
            return Objects.equals(this.paramName, named.paramName) && Objects.equals(this.fileName, named.fileName) && Objects.equals(this.fileContent, named.fileContent) && Objects.equals(this.fileContentAsBytes, named.fileContentAsBytes) && Objects.equals(this.fileContentFromFileAsBytes, named.fileContentFromFileAsBytes) && Objects.equals(this.contentType, named.contentType) && Objects.equals(this.fileNameCommand, named.fileNameCommand) && Objects.equals(this.fileContentCommand, named.fileContentCommand) && Objects.equals(this.contentTypeCommand, named.contentTypeCommand);
        }

        public int hashCode() {
            return Objects.hash(this.paramName, this.fileName, this.fileContent, this.fileContentAsBytes, this.fileContentFromFileAsBytes, this.contentType, this.fileNameCommand, this.fileContentCommand, this.contentTypeCommand);
        }

        public String toString() {
            return "Named{paramName='" + this.paramName + '\'' + ", fileName='" + this.fileName + '\'' + ", fileContent='" + this.fileContent + '\'' + ", fileContentAsBytes='" + this.fileContentAsBytes + '\'' + ", fileContentFromFileAsBytes='" + this.fileContentFromFileAsBytes + '\'' + ", contentType='" + this.contentType + '\'' + ", fileNameCommand='" + this.fileNameCommand + '\'' + ", fileContentCommand='" + this.fileContentCommand + '\'' + ", contentTypeCommand='" + this.contentTypeCommand + '\'' + '}';
        }
    }

    public static class Multipart {
        public Map<String, String> params = new LinkedHashMap<String, String>();
        public List<Named> named = new ArrayList<Named>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Multipart multipart = (Multipart)o;
            return Objects.equals(this.params, multipart.params) && Objects.equals(this.named, multipart.named);
        }

        public int hashCode() {
            return Objects.hash(this.params, this.named);
        }

        public String toString() {
            return "Multipart{params=" + this.params + ", named=" + this.named + '}';
        }
    }

    public static class Request {
        public String method;
        public String url;
        public String urlPath;
        public Map<String, Object> queryParameters = new LinkedHashMap<String, Object>();
        public Map<String, Object> headers = new LinkedHashMap<String, Object>();
        public Map<String, Object> cookies = new LinkedHashMap<String, Object>();
        public Object body;
        public String bodyFromFile;
        public String bodyFromFileAsBytes;
        public StubMatchers matchers = new StubMatchers();
        public Multipart multipart;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.method, request.method) && Objects.equals(this.url, request.url) && Objects.equals(this.urlPath, request.urlPath) && Objects.equals(this.queryParameters, request.queryParameters) && Objects.equals(this.headers, request.headers) && Objects.equals(this.cookies, request.cookies) && Objects.equals(this.body, request.body) && Objects.equals(this.bodyFromFile, request.bodyFromFile) && Objects.equals(this.bodyFromFileAsBytes, request.bodyFromFileAsBytes) && Objects.equals(this.matchers, request.matchers) && Objects.equals(this.multipart, request.multipart);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.url, this.urlPath, this.queryParameters, this.headers, this.cookies, this.body, this.bodyFromFile, this.bodyFromFileAsBytes, this.matchers, this.multipart);
        }

        public String toString() {
            return "Request{method='" + this.method + '\'' + ", url='" + this.url + '\'' + ", urlPath='" + this.urlPath + '\'' + ", queryParameters=" + this.queryParameters + ", headers=" + this.headers + ", cookies=" + this.cookies + ", body=" + this.body + ", bodyFromFile='" + this.bodyFromFile + '\'' + ", bodyFromFileAsBytes='" + this.bodyFromFileAsBytes + '\'' + ", matchers=" + this.matchers + ", multipart=" + this.multipart + '}';
        }
    }
}

