/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.kafka;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessage;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

class ContractVerifierKafkaHelper
extends ContractVerifierMessaging<Message<?>> {
    ContractVerifierKafkaHelper(MessageVerifier<Message<?>> exchange) {
        super(exchange);
    }

    @Override
    protected ContractVerifierMessage convert(Message<?> message) {
        return new ContractVerifierMessage(message.getPayload(), (Map<String, Object>)this.convertHeaders((Map<String, Object>)message.getHeaders()));
    }

    private MessageHeaders convertHeaders(Map<String, Object> headers) {
        return new MessageHeaders(headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.maybeConvertValue(e.getValue()))));
    }

    private Object maybeConvertValue(Object value) {
        if (!(value instanceof byte[])) {
            return value;
        }
        return new String((byte[])value, StandardCharsets.UTF_8);
    }
}

