/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.JUnit4IgnoreMethodAnnotation;
import org.springframework.cloud.contract.verifier.builder.JUnit4MethodAnnotation;
import org.springframework.cloud.contract.verifier.builder.JUnit5IgnoreMethodAnnotation;
import org.springframework.cloud.contract.verifier.builder.JUnit5MethodAnnotation;
import org.springframework.cloud.contract.verifier.builder.MethodAnnotations;
import org.springframework.cloud.contract.verifier.builder.SingleMethodBuilder;
import org.springframework.cloud.contract.verifier.builder.SpockIgnoreMethodAnnotation;
import org.springframework.cloud.contract.verifier.builder.TestNGMethodAnnotation;

class MethodAnnotationBuilder {
    private final SingleMethodBuilder singleMethodBuilder;
    private final BlockBuilder builder;
    private final GeneratedClassMetaData metaData;

    MethodAnnotationBuilder(SingleMethodBuilder singleMethodBuilder) {
        this.singleMethodBuilder = singleMethodBuilder;
        this.builder = singleMethodBuilder.blockBuilder;
        this.metaData = singleMethodBuilder.generatedClassMetaData;
    }

    MethodAnnotationBuilder jUnit4() {
        this.singleMethodBuilder.methodAnnotation(new JUnit4MethodAnnotation(this.builder, this.metaData), new JUnit4IgnoreMethodAnnotation(this.builder, this.metaData));
        return this;
    }

    MethodAnnotationBuilder jUnit5() {
        this.singleMethodBuilder.methodAnnotation(new JUnit5MethodAnnotation(this.builder, this.metaData), new JUnit5IgnoreMethodAnnotation(this.builder, this.metaData));
        return this;
    }

    MethodAnnotationBuilder testNG() {
        this.singleMethodBuilder.methodAnnotation((MethodAnnotations)new TestNGMethodAnnotation(this.builder, this.metaData));
        return this;
    }

    MethodAnnotationBuilder spock() {
        this.singleMethodBuilder.methodAnnotation((MethodAnnotations)new SpockIgnoreMethodAnnotation(this.builder, this.metaData));
        return this;
    }

    SingleMethodBuilder build() {
        return this.singleMethodBuilder;
    }
}

