/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.dsl.wiremock;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import groovy.lang.GString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractTemplate;
import org.springframework.cloud.contract.spec.internal.Body;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.verifier.template.HandlebarsTemplateProcessor;
import org.springframework.cloud.contract.verifier.template.TemplateProcessor;
import org.springframework.cloud.contract.verifier.util.ContentType;
import org.springframework.cloud.contract.verifier.util.ContentUtils;
import org.springframework.cloud.contract.verifier.util.MapConverter;

abstract class BaseWireMockStubStrategy {
    private static final String WRAPPER = "UNQUOTE_ME";
    protected final TemplateProcessor processor = this.templateProcessor();
    protected final ContractTemplate template = this.contractTemplate();
    protected final Contract contract;

    protected BaseWireMockStubStrategy(Contract contract) {
        this.contract = contract;
    }

    private TemplateProcessor templateProcessor() {
        return new HandlebarsTemplateProcessor();
    }

    private ContractTemplate contractTemplate() {
        return new HandlebarsTemplateProcessor();
    }

    protected Object getStubSideValue(Object object) {
        return MapConverter.getStubSideValues(object);
    }

    String parseBody(Object value, ContentType contentType) {
        return this.parseBody(value.toString(), contentType);
    }

    String parseBody(FromFileProperty value, ContentType contentType) {
        return value.asString();
    }

    String parseBody(Boolean value, ContentType contentType) {
        return value.toString();
    }

    String parseBody(Map<?, ?> map, ContentType contentType) {
        Object transformedMap = MapConverter.getStubSideValues(map);
        transformedMap = this.transformMapIfRequestPresent(transformedMap);
        String json = BaseWireMockStubStrategy.toJson(transformedMap);
        String unquotedJson = json.replace("\"UNQUOTE_ME", "").replace("UNQUOTE_ME\"", " ");
        String unescapedJson = unquotedJson.replace("\\/", "/");
        return this.parseBody(unescapedJson, contentType);
    }

    private Object transformMapIfRequestPresent(Object transformedMap) {
        Body requestBody = this.contract.getRequest().getBody();
        if (requestBody == null) {
            return transformedMap;
        }
        String testSideBody = BaseWireMockStubStrategy.toJson(MapConverter.getTestSideValues(requestBody));
        DocumentContext context = JsonPath.parse((String)testSideBody);
        return this.processEntriesForTemplating(transformedMap, context);
    }

    private Object processEntriesForTemplating(Object transformedMap, DocumentContext context) {
        return MapConverter.transformValues(transformedMap, val -> {
            if (val instanceof String && this.processor.containsJsonPathTemplateEntry((String)val)) {
                String jsonPath = this.processor.jsonPathFromTemplateEntry((String)val);
                if (jsonPath == null) {
                    return val;
                }
                Object value = context.read(jsonPath, new Predicate[0]);
                if (value instanceof String) {
                    return val;
                }
                return WRAPPER + val + WRAPPER;
            }
            if (val instanceof String && this.processor.containsTemplateEntry((String)val) && this.template.escapedBody().equals(val)) {
                return this.template.escapedBody();
            }
            return val;
        });
    }

    String parseBody(List<?> list, ContentType contentType) {
        ArrayList result = new ArrayList();
        list.forEach(l -> {
            if (l instanceof Map) {
                result.add(MapConverter.getStubSideValues(l));
            } else if (l instanceof List) {
                result.add(this.parseBody((List)l, contentType));
            } else {
                result.add(this.parseBody(l, contentType));
            }
        });
        return this.parseBody(BaseWireMockStubStrategy.toJson(result), contentType);
    }

    String parseBody(GString value, ContentType contentType) {
        Object processedValue = ContentUtils.extractValue(value, contentType, o -> o instanceof DslProperty ? ((DslProperty)o).getClientValue() : o);
        if (processedValue instanceof GString) {
            return this.parseBody(processedValue.toString(), contentType);
        }
        return this.parseBody(processedValue, contentType);
    }

    String parseBody(String value, ContentType contentType) {
        return value;
    }

    private static String toJson(Object value) {
        try {
            if (value instanceof Map) {
                Object convertedMap = MapConverter.transformValues(value, v -> v instanceof GString ? ((GString)v).toString() : v);
                String jsonOutput = new ObjectMapper().writeValueAsString(convertedMap);
                return jsonOutput.replaceAll("\\\\\\\\\\\\", "\\\\");
            }
            return new ObjectMapper().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("The current object [" + value + "] could not be serialized");
        }
    }

    protected ContentType tryToGetContentType(Object body, Headers headers) {
        ContentType contentType = ContentUtils.recognizeContentTypeFromHeader(headers);
        if (ContentType.UNKNOWN == contentType) {
            if (body == null) {
                return ContentType.UNKNOWN;
            }
            return ContentUtils.getClientContentType(body);
        }
        return contentType;
    }
}

