/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.stream;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierSender;
import org.springframework.cloud.contract.verifier.messaging.stream.ContractVerifierStreamMessageBuilder;
import org.springframework.cloud.contract.verifier.messaging.stream.DefaultChannels;
import org.springframework.cloud.contract.verifier.messaging.stream.DestinationResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

class StreamFromBinderMappingMessageSender
implements MessageVerifierSender<Message<?>> {
    private static final Log log = LogFactory.getLog(StreamFromBinderMappingMessageSender.class);
    private final ApplicationContext context;
    private final DestinationResolver resolver;
    private final ContractVerifierStreamMessageBuilder builder = new ContractVerifierStreamMessageBuilder();

    StreamFromBinderMappingMessageSender(ApplicationContext context, DestinationResolver resolver) {
        this.context = context;
        this.resolver = resolver;
    }

    @Override
    public <T> void send(T payload, Map<String, Object> headers, String destination, YamlContract contract) {
        this.send(this.builder.create(payload, headers), destination, contract);
    }

    @Override
    public void send(Message<?> message, String destination, YamlContract contract) {
        try {
            MessageChannel messageChannel = (MessageChannel)this.context.getBean(this.resolver.resolvedDestination(destination, DefaultChannels.OUTPUT), MessageChannel.class);
            messageChannel.send(message);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while trying to send a message [" + message + "] to a channel with name [" + destination + "]"), (Throwable)e);
            throw e;
        }
    }
}

