/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Iterator;
import java.util.Set;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.When;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.MapConverter;

class JaxRsRequestHeadersWhen
implements When {
    private final BlockBuilder blockBuilder;
    private final BodyParser bodyParser;

    JaxRsRequestHeadersWhen(BlockBuilder blockBuilder, BodyParser bodyParser) {
        this.blockBuilder = blockBuilder;
        this.bodyParser = bodyParser;
    }

    @Override
    public MethodVisitor<When> apply(SingleContractMetadata metadata) {
        this.appendHeaders(metadata.getContract().getRequest());
        return this;
    }

    private void appendHeaders(Request request) {
        Iterator iterator = request.getHeaders().getEntries().stream().filter(header -> !this.headerToIgnore((Header)header)).iterator();
        while (iterator.hasNext()) {
            Header header2 = (Header)iterator.next();
            String text = ".header(\"" + header2.getName() + "\", " + this.headerValue(header2) + ")";
            if (iterator.hasNext()) {
                this.blockBuilder.addLine(text);
                continue;
            }
            this.blockBuilder.addIndented(text);
        }
    }

    private String headerValue(Header header) {
        Object headerServerValue = header.getServerValue();
        if (headerServerValue instanceof ExecutionProperty) {
            return ((ExecutionProperty)headerServerValue).getExecutionCommand();
        }
        return this.bodyParser.quotedLongText(MapConverter.getTestSideValuesForNonBody(header.getServerValue()));
    }

    private boolean headerToIgnore(Header header) {
        return this.contentTypeOrAccept(header) || this.headerOfAbsentType(header);
    }

    private boolean contentTypeOrAccept(Header header) {
        return "Content-Type".equalsIgnoreCase(header.getName()) || "Accept".equalsIgnoreCase(header.getName());
    }

    private boolean headerOfAbsentType(Header header) {
        return header.getServerValue() instanceof MatchingStrategy && ((MatchingStrategy)header.getServerValue()).getType() == MatchingStrategy.Type.ABSENT;
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        return metadata.getContract().getRequest().getHeaders() != null && !metadata.getContract().getRequest().getHeaders().getEntries().isEmpty() && !this.hasHeaderOnlyContentTypeOrAccept(metadata);
    }

    private boolean hasHeaderOnlyContentTypeOrAccept(SingleContractMetadata metadata) {
        Set entries = metadata.getContract().getRequest().getHeaders().getEntries();
        long filteredOut = entries.stream().filter(this::headerToIgnore).count();
        return filteredOut == (long)entries.size();
    }
}

