/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.dsl.wiremock;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import groovy.lang.GString;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.Response;
import org.springframework.cloud.contract.verifier.dsl.wiremock.BaseWireMockStubStrategy;
import org.springframework.cloud.contract.verifier.dsl.wiremock.DefaultResponseTransformer;
import org.springframework.cloud.contract.verifier.dsl.wiremock.WireMockExtensions;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.ContentType;
import org.springframework.cloud.contract.verifier.util.MapConverter;
import org.springframework.core.io.support.SpringFactoriesLoader;

class WireMockResponseStubStrategy
extends BaseWireMockStubStrategy {
    private final Response response;
    private final ContentType contentType;
    private final SingleContractMetadata contractMetadata;

    WireMockResponseStubStrategy(Contract groovyDsl, SingleContractMetadata singleContractMetadata) {
        super(groovyDsl);
        this.response = groovyDsl.getResponse();
        this.contentType = this.contentType(singleContractMetadata);
        this.contractMetadata = singleContractMetadata;
    }

    protected ContentType contentType(SingleContractMetadata singleContractMetadata) {
        return singleContractMetadata.getEvaluatedOutputStubContentType();
    }

    ResponseDefinition buildClientResponseContent() {
        if (this.response == null) {
            return null;
        }
        ResponseDefinitionBuilder builder = new ResponseDefinitionBuilder().withStatus(((Integer)MapConverter.getStubSideValues(this.response.getStatus())).intValue());
        this.appendHeaders(builder);
        this.appendBody(builder);
        this.appendResponseDelayTime(builder);
        builder.withTransformers(this.responseTransformerNames());
        return builder.build();
    }

    private String[] responseTransformerNames() {
        List wireMockExtensions = SpringFactoriesLoader.loadFactories(WireMockExtensions.class, null);
        if (!wireMockExtensions.isEmpty()) {
            return (String[])wireMockExtensions.stream().map(WireMockExtensions::extensions).flatMap(Collection::stream).map(Extension::getName).toArray(String[]::new);
        }
        return new String[]{new DefaultResponseTransformer().getName(), "spring-cloud-contract"};
    }

    private void appendHeaders(ResponseDefinitionBuilder builder) {
        if (this.response.getHeaders() != null) {
            HttpHeaders headers = this.response.getHeaders().getEntries().stream().map(it -> new HttpHeader(it.getName(), new String[]{MapConverter.getStubSideValues(it.getClientValue()).toString()})).collect(Collectors.collectingAndThen(Collectors.toList(), HttpHeaders::new));
            builder.withHeaders(headers);
        }
    }

    private void appendBody(ResponseDefinitionBuilder builder) {
        if (this.response.getBody() != null) {
            Object body = MapConverter.getStubSideValues(this.response.getBody(), this.parsingClosureForContentType());
            if (body instanceof byte[]) {
                builder.withBody((byte[])body);
            } else if (body instanceof FromFileProperty && ((FromFileProperty)body).isByte()) {
                builder.withBody(((FromFileProperty)body).asBytes());
            } else if (body instanceof Map) {
                builder.withBody(this.parseBody((Map)body, this.contentType));
            } else if (body instanceof List) {
                builder.withBody(this.parseBody((List)body, this.contentType));
            } else if (body instanceof GString) {
                builder.withBody(this.parseBody((GString)body, this.contentType));
            } else {
                builder.withBody(this.parseBody(body, this.contentType));
            }
        }
    }

    Function<String, Object> parsingClosureForContentType() {
        return this.contractMetadata.getDefinedOutputStubContentType().contains("/stream") ? MapConverter.IDENTITY : MapConverter.JSON_PARSING_FUNCTION;
    }

    private void appendResponseDelayTime(ResponseDefinitionBuilder builder) {
        if (this.response.getDelay() != null) {
            builder.withFixedDelay((Integer)this.response.getDelay().getClientValue());
        }
    }
}

