/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractConverter;
import org.springframework.cloud.contract.verifier.converter.YamlContractConverter;
import org.springframework.cloud.contract.verifier.util.ContractVerifierDslConverter;
import org.springframework.core.io.support.SpringFactoriesLoader;

public final class ContractScanner {
    private static final Log log = LogFactory.getLog(ContractScanner.class);

    private ContractScanner() {
        throw new IllegalStateException("Can't instantiate an utility class");
    }

    public static Collection<Contract> collectContractDescriptors(File rootDirectory) {
        return ContractScanner.collectContractDescriptors(rootDirectory, file -> true);
    }

    public static Collection<Contract> collectContractDescriptors(File rootDirectory, Predicate<File> predicate) {
        try {
            return Files.walk(rootDirectory.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(file -> !file.isDirectory()).filter(predicate).map(ContractScanner::doCollectContractDescriptors).flatMap(Collection::stream).collect(Collectors.toList());
        }
        catch (IOException e) {
            log.warn((Object)"Exception occurred while trying to parse file", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static Collection<Contract> doCollectContractDescriptors(File file) {
        if (ContractScanner.isContractDescriptor(file)) {
            return ContractVerifierDslConverter.convertAsCollection(file.getParentFile(), file);
        }
        ContractConverter<?> converter = ContractScanner.contractConverter(file);
        if (converter != null && converter.isAccepted(file)) {
            return converter.convertFrom(file);
        }
        if (YamlContractConverter.INSTANCE.isAccepted(file)) {
            return YamlContractConverter.INSTANCE.convertFrom(file);
        }
        return Collections.emptyList();
    }

    private static ContractConverter<?> contractConverter(File file) {
        return SpringFactoriesLoader.loadFactories(ContractConverter.class, null).stream().filter(converter -> converter.isAccepted(file)).findFirst().orElse(null);
    }

    private static boolean isContractDescriptor(File file) {
        return ContractVerifierDslConverter.INSTANCE.isAccepted(file);
    }
}

