/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import com.github.tomakehurst.wiremock.core.Options;
import io.undertow.Undertow;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.springframework.cloud.contract.wiremock.ContainerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

class ContainerConfiguration {
    ContainerConfiguration() {
    }

    @Configuration
    @ConditionalOnMissingBean(value={EmbeddedServletContainerFactory.class})
    @ConditionalOnClass(value={JettyEmbeddedServletContainerFactory.class, ServerConnector.class})
    static class JettyContainerConfiguration {
        @Autowired
        private ContainerProperties container;
        @Autowired
        private Options options;
        private ServerConnector connector;

        JettyContainerConfiguration() {
        }

        @Bean
        public EmbeddedServletContainerFactory servletContainer() {
            JettyEmbeddedServletContainerFactory jetty = new JettyEmbeddedServletContainerFactory();
            if (this.options.httpsSettings().enabled()) {
                jetty.addServerCustomizers(new JettyServerCustomizer[]{new JettyServerCustomizer(){

                    public void customize(Server server) {
                        server.addConnector(JettyContainerConfiguration.this.createStandardConnector(server));
                    }
                }});
            }
            return jetty;
        }

        private Connector createStandardConnector(Server server) {
            ServerConnector connector = new ServerConnector(server, -1, -1);
            connector.setHost("localhost");
            connector.setPort(this.options.portNumber());
            for (ConnectionFactory connectionFactory : connector.getConnectionFactories()) {
                if (!(connectionFactory instanceof HttpConfiguration.ConnectionFactory)) continue;
                ((HttpConfiguration.ConnectionFactory)connectionFactory).getHttpConfiguration().setSendServerVersion(false);
            }
            this.connector = connector;
            return connector;
        }

        @EventListener
        public void serverUp(EmbeddedServletContainerInitializedEvent event) {
            if (this.connector != null) {
                this.container.setLocalPort(this.connector.getLocalPort());
                this.container.setLocalHttpsPort(event.getEmbeddedServletContainer().getPort());
            }
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={EmbeddedServletContainerFactory.class})
    @ConditionalOnClass(value={UndertowEmbeddedServletContainerFactory.class, Undertow.Builder.class})
    static class UndertowContainerConfiguration {
        @Autowired
        private Options options;
        @Autowired
        private ContainerProperties container;
        private Integer port;

        UndertowContainerConfiguration() {
        }

        @Bean
        public EmbeddedServletContainerFactory servletContainer() {
            UndertowEmbeddedServletContainerFactory undertow = new UndertowEmbeddedServletContainerFactory();
            if (this.options.httpsSettings().enabled()) {
                undertow.addBuilderCustomizers(new UndertowBuilderCustomizer[]{new UndertowBuilderCustomizer(){

                    public void customize(Undertow.Builder builder) {
                        builder.addHttpListener(UndertowContainerConfiguration.this.options.portNumber(), "localhost");
                        UndertowContainerConfiguration.this.port = UndertowContainerConfiguration.this.options.portNumber();
                    }
                }});
            }
            return undertow;
        }

        @EventListener
        public void serverUp(EmbeddedServletContainerInitializedEvent event) {
            if (this.port != null) {
                this.container.setLocalPort(this.port);
                this.container.setLocalHttpsPort(event.getEmbeddedServletContainer().getPort());
            }
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={EmbeddedServletContainerFactory.class})
    @ConditionalOnClass(value={TomcatEmbeddedServletContainerFactory.class, org.apache.catalina.connector.Connector.class})
    static class TomcatContainerConfiguration {
        @Autowired
        private Options options;
        @Autowired
        private ContainerProperties container;
        private org.apache.catalina.connector.Connector connector;

        TomcatContainerConfiguration() {
        }

        @Bean
        public EmbeddedServletContainerFactory servletContainer() {
            TomcatEmbeddedServletContainerFactory tomcat = new TomcatEmbeddedServletContainerFactory();
            if (this.options.httpsSettings().enabled()) {
                tomcat.addAdditionalTomcatConnectors(new org.apache.catalina.connector.Connector[]{this.createStandardConnector()});
            }
            return tomcat;
        }

        @EventListener
        public void serverUp(EmbeddedServletContainerInitializedEvent event) {
            if (this.connector != null) {
                this.container.setLocalPort(this.connector.getLocalPort());
                this.container.setLocalHttpsPort(event.getEmbeddedServletContainer().getPort());
            }
        }

        private org.apache.catalina.connector.Connector createStandardConnector() {
            org.apache.catalina.connector.Connector connector = new org.apache.catalina.connector.Connector("org.apache.coyote.http11.Http11NioProtocol");
            connector.setPort(this.options.portNumber());
            this.connector = connector;
            return connector;
        }
    }
}

