/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.cloud.test.TestSocketUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@Order(value=0x7FFFFFFF)
public class WireMockApplicationListener
implements ApplicationListener<ApplicationPreparedEvent> {
    private static final Log log = LogFactory.getLog(WireMockApplicationListener.class);

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        this.registerPort(event.getApplicationContext().getEnvironment());
    }

    private void registerPort(ConfigurableEnvironment environment) {
        int httpsPortProperty;
        Integer httpPortProperty = (Integer)environment.getProperty("wiremock.server.port", Integer.class);
        if (httpPortProperty != null && this.isHttpDynamic(httpPortProperty)) {
            this.registerPropertySourceForDynamicEntries(environment, "wiremock.server.port", 10000, 12500, "wiremock.server.port-dynamic");
            if (log.isDebugEnabled()) {
                log.debug((Object)"Registered property source for dynamic http port");
            }
        } else {
            Map<String, Object> source = this.getWireMockSource(environment);
            Integer port = Optional.ofNullable(httpPortProperty).orElse(8080);
            source.put("wiremock.server.port", port);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registered WireMock server port property to the <" + port + "> value"));
            }
        }
        if (this.isHttpsDynamic(httpsPortProperty = ((Integer)environment.getProperty("wiremock.server.https-port", Integer.class, (Object)0)).intValue())) {
            this.registerPropertySourceForDynamicEntries(environment, "wiremock.server.https-port", 12500, 15000, "wiremock.server.https-port-dynamic");
            if (log.isDebugEnabled()) {
                log.debug((Object)"Registered property source for dynamic https port");
            }
        } else if (httpsPortProperty == -1) {
            Map<String, Object> source = this.getWireMockSource(environment);
            source.put("wiremock.server.https-port-dynamic", true);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Registered property source for dynamic https with https port property set to -1");
            }
        }
    }

    private Map<String, Object> getWireMockSource(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = environment.getPropertySources();
        this.addPropertySource(propertySources);
        Map source = (Map)((MapPropertySource)propertySources.get("wiremock")).getSource();
        return source;
    }

    private boolean isHttpsDynamic(int httpsPortProperty) {
        return httpsPortProperty == 0;
    }

    private boolean isHttpDynamic(Integer httpPortProperty) {
        return httpPortProperty.equals(0);
    }

    private void registerPropertySourceForDynamicEntries(ConfigurableEnvironment environment, String portProperty, int minPort, int maxPort, String dynamicPortProperty) {
        Map<String, Object> source = this.getWireMockSource(environment);
        int port = TestSocketUtils.findAvailableTcpPort((int)minPort, (int)maxPort);
        source.put(portProperty, port);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered property source for property [" + portProperty + "] with value [" + port + "]"));
        }
        source.put(dynamicPortProperty, true);
    }

    private void addPropertySource(MutablePropertySources propertySources) {
        if (!propertySources.contains("wiremock")) {
            propertySources.addFirst((PropertySource)new MapPropertySource("wiremock", new HashMap()));
        } else {
            PropertySource wiremock = propertySources.remove("wiremock");
            propertySources.addFirst(wiremock);
        }
    }
}

