/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.audit.repository.jpa;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.cloud.dataflow.audit.repository.AuditRecordRepositoryCustom;
import org.springframework.cloud.dataflow.core.AuditActionType;
import org.springframework.cloud.dataflow.core.AuditOperationType;
import org.springframework.cloud.dataflow.core.AuditRecord;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.QueryUtils;

public class AuditRecordRepositoryImpl
implements AuditRecordRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<AuditRecord> findByActionTypeAndOperationTypeAndDate(AuditOperationType[] operations, AuditActionType[] actions, Instant fromDate, Instant toDate, Pageable pageable) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(AuditRecord.class);
        Root auditRecordRoot = query.from(AuditRecord.class);
        Path auditAction = auditRecordRoot.get("auditAction");
        Path auditOperation = auditRecordRoot.get("auditOperation");
        Path createdOn = auditRecordRoot.get("createdOn");
        Predicate datePredicate = fromDate != null && toDate == null ? cb.greaterThanOrEqualTo((Expression)createdOn, (Comparable)fromDate) : (fromDate == null && toDate != null ? cb.lessThanOrEqualTo((Expression)createdOn, (Comparable)toDate) : (fromDate != null && toDate != null ? cb.between((Expression)createdOn, (Comparable)fromDate, (Comparable)toDate) : null));
        ArrayList<Predicate> auditActionPredicates = new ArrayList<Predicate>();
        if (actions != null && actions.length > 0) {
            for (AuditActionType action : actions) {
                auditActionPredicates.add(cb.equal((Expression)auditAction, (Object)action));
            }
        }
        ArrayList<Predicate> auditOperationsPredicates = new ArrayList<Predicate>();
        if (operations != null && operations.length > 0) {
            for (AuditOperationType operation : operations) {
                auditOperationsPredicates.add(cb.equal((Expression)auditOperation, (Object)operation));
            }
        }
        ArrayList<Predicate> finalQueryPredicates = new ArrayList<Predicate>();
        if (!auditActionPredicates.isEmpty()) {
            Predicate auditActionPredicatesOr = cb.or(auditActionPredicates.toArray(new Predicate[0]));
            finalQueryPredicates.add(auditActionPredicatesOr);
        }
        if (datePredicate != null) {
            finalQueryPredicates.add(datePredicate);
        }
        if (!auditOperationsPredicates.isEmpty()) {
            Predicate auditOperationsPredicatesOr = cb.or(auditOperationsPredicates.toArray(new Predicate[0]));
            finalQueryPredicates.add(auditOperationsPredicatesOr);
        }
        CriteriaQuery select = query.select((Selection)auditRecordRoot);
        if (!finalQueryPredicates.isEmpty()) {
            select.where(finalQueryPredicates.toArray(new Predicate[0]));
        }
        if (pageable.getSort().isUnsorted()) {
            select.orderBy(QueryUtils.toOrders((Sort)pageable.getSort().and(Sort.by((String[])new String[]{"id"})).ascending(), (From)auditRecordRoot, (CriteriaBuilder)cb));
        } else {
            select.orderBy(QueryUtils.toOrders((Sort)pageable.getSort(), (From)auditRecordRoot, (CriteriaBuilder)cb));
        }
        TypedQuery typedQuery = this.entityManager.createQuery(select);
        typedQuery.setFirstResult((int)pageable.getOffset());
        typedQuery.setMaxResults(pageable.getPageSize());
        List resultList = typedQuery.getResultList();
        CriteriaQuery countQuery = cb.createQuery(Long.class);
        countQuery.select((Selection)cb.count((Expression)countQuery.from(AuditRecord.class)));
        if (!finalQueryPredicates.isEmpty()) {
            countQuery.where(finalQueryPredicates.toArray(new Predicate[0]));
        }
        Long totalCount = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        return new PageImpl(resultList, pageable, totalCount.longValue());
    }
}

