/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.audit.service;

import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.rest.util.ArgumentSanitizer;
import org.springframework.cloud.scheduler.spi.core.ScheduleRequest;
import org.springframework.util.Assert;

public class AuditServiceUtils {
    public static final String APP_NAME = "APP_NAME";
    public static final String APP_TYPE = "APP_TYPE";
    public static final String APP_VERSION = "APP_VERSION";
    public static final String APP_IS_DEFAULT = "APP_IS_DEFAULT";
    public static final String APP_URI = "uri";
    public static final String APP_META_DATA_URI = "metaDataUri";
    public static final String STREAM_DEFINITION_DSL_TEXT = "streamDefinitionDslText";
    public static final String TASK_DEFINITION_NAME = "taskDefinitionName";
    public static final String TASK_DEFINITION_PROPERTIES = "taskDefinitionProperties";
    public static final String DEPLOYMENT_PROPERTIES = "deploymentProperties";
    public static final String COMMANDLINE_ARGUMENTS = "commandlineArguments";
    private final ArgumentSanitizer argumentSanitizer = new ArgumentSanitizer();

    public Map<String, Object> convertAppRegistrationToAuditData(AppRegistration appRegistration) {
        HashMap<String, Object> auditData = new HashMap<String, Object>(4);
        auditData.put(APP_NAME, appRegistration.getName());
        auditData.put(APP_TYPE, appRegistration.getType());
        auditData.put(APP_VERSION, appRegistration.getVersion());
        auditData.put(APP_IS_DEFAULT, appRegistration.isDefaultVersion());
        auditData.put(APP_URI, appRegistration.getUri());
        auditData.put(APP_META_DATA_URI, appRegistration.getMetadataUri());
        return auditData;
    }

    public String convertStreamDefinitionToAuditData(StreamDefinition streamDefinition) {
        return this.argumentSanitizer.sanitizeStream(streamDefinition);
    }

    public Map<String, String> sanitizeProperties(Map<String, String> properties) {
        return this.argumentSanitizer.sanitizeProperties(properties);
    }

    public Map<String, Object> convertStreamDefinitionToAuditData(StreamDefinition streamDefinition, Map<String, String> deploymentProperties) {
        HashMap<String, Object> auditedData = new HashMap<String, Object>(2);
        auditedData.put(STREAM_DEFINITION_DSL_TEXT, this.argumentSanitizer.sanitizeStream(streamDefinition));
        auditedData.put(DEPLOYMENT_PROPERTIES, this.argumentSanitizer.sanitizeProperties(deploymentProperties));
        return auditedData;
    }

    public Map<String, Object> convertScheduleRequestToAuditData(ScheduleRequest scheduleRequest) {
        Assert.notNull((Object)scheduleRequest, (String)"scheduleRequest must not be null");
        Assert.hasText((String)scheduleRequest.getScheduleName(), (String)"The scheduleName of the scheduleRequest must not be null or empty");
        Assert.notNull((Object)scheduleRequest.getDefinition(), (String)"The task definition of the scheduleRequest must not be null");
        HashMap<String, Object> auditedData = new HashMap<String, Object>(3);
        auditedData.put(TASK_DEFINITION_NAME, scheduleRequest.getDefinition().getName());
        if (scheduleRequest.getDefinition().getProperties() != null) {
            auditedData.put(TASK_DEFINITION_PROPERTIES, this.argumentSanitizer.sanitizeProperties(scheduleRequest.getDefinition().getProperties()));
        }
        if (scheduleRequest.getDeploymentProperties() != null) {
            auditedData.put(DEPLOYMENT_PROPERTIES, this.argumentSanitizer.sanitizeProperties(scheduleRequest.getDeploymentProperties()));
        }
        if (scheduleRequest.getCommandlineArguments() != null) {
            auditedData.put(COMMANDLINE_ARGUMENTS, this.argumentSanitizer.sanitizeArguments(scheduleRequest.getCommandlineArguments()));
        }
        return auditedData;
    }
}

