/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.ExpansionStrategy;
import org.springframework.cloud.dataflow.completion.ProposalsCollectorSupportUtils;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;

class AddAppOptionsExpansionStrategy
implements ExpansionStrategy {
    private final ProposalsCollectorSupportUtils collectorSupport;

    public AddAppOptionsExpansionStrategy(AppRegistryService appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        this.collectorSupport = new ProposalsCollectorSupportUtils(appRegistry, metadataResolver);
    }

    @Override
    public boolean addProposals(String text, StreamDefinition streamDefinition, int detailLevel, List<CompletionProposal> collector) {
        StreamAppDefinition lastApp = (StreamAppDefinition)streamDefinition.getDeploymentOrderIterator().next();
        AppRegistration appRegistration = this.collectorSupport.findAppRegistration(lastApp.getName(), CompletionUtils.determinePotentialTypes(lastApp, streamDefinition.getAppDefinitions().size() > 1));
        if (appRegistration != null) {
            HashSet<String> alreadyPresentOptions = new HashSet<String>(lastApp.getProperties().keySet());
            this.collectorSupport.addPropertiesProposals(text, "", appRegistration, alreadyPresentOptions, collector, detailLevel);
        }
        return false;
    }
}

