/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.ProposalsCollectorSupportUtils;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.ValueHintProvider;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;

public class ConfigurationPropertyValueHintRecoveryStrategy
extends StacktraceFingerprintingRecoveryStrategy<CheckPointedParseException> {
    private final ProposalsCollectorSupportUtils collectorSupport;
    @Autowired
    private ValueHintProvider[] valueHintProviders = new ValueHintProvider[0];

    ConfigurationPropertyValueHintRecoveryStrategy(AppRegistryService appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        super(CheckPointedParseException.class, "foo --bar=", "foo | wizz --bar=");
        this.collectorSupport = new ProposalsCollectorSupportUtils(appRegistry, metadataResolver);
    }

    @Override
    public void addProposals(String dsl, CheckPointedParseException exception, int detailLevel, List<CompletionProposal> collector) {
        String propertyName = this.recoverPropertyName(exception);
        AppRegistration lastAppRegistration = this.lookupLastApp(exception);
        if (lastAppRegistration != null) {
            this.collectorSupport.addValueHintsProposals(dsl, lastAppRegistration, collector, propertyName, this.valueHintProviders);
        }
    }

    private AppRegistration lookupLastApp(CheckPointedParseException exception) {
        String safe = exception.getExpressionStringUntilCheckpoint();
        StreamDefinition streamDefinition = new StreamDefinition("__dummy", safe);
        StreamAppDefinition lastApp = (StreamAppDefinition)streamDefinition.getDeploymentOrderIterator().next();
        return this.collectorSupport.findAppRegistration(lastApp.getName(), CompletionUtils.determinePotentialTypes(lastApp, streamDefinition.getAppDefinitions().size() > 1));
    }

    private String recoverPropertyName(CheckPointedParseException exception) {
        List tokens = exception.getTokens();
        int tokenPointer = tokens.size() - 1;
        while (!((Token)tokens.get(tokenPointer - 1)).isKind(TokenKind.DOUBLE_MINUS)) {
            --tokenPointer;
        }
        int equalSignPointer = tokens.size() - 1;
        StringBuilder builder = new StringBuilder();
        while (tokenPointer < equalSignPointer) {
            Token t = (Token)tokens.get(tokenPointer);
            if (t.isIdentifier()) {
                builder.append(t.stringValue());
            } else {
                builder.append(t.getKind().getTokenChars());
            }
            ++tokenPointer;
        }
        return builder.toString();
    }
}

