/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingRecoveryStrategy;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;

class DestinationNameYieldsAppsRecoveryStrategy
extends StacktraceFingerprintingRecoveryStrategy<CheckPointedParseException> {
    private final AppRegistryService appRegistry;

    public DestinationNameYieldsAppsRecoveryStrategy(AppRegistryService appRegistry) {
        super(CheckPointedParseException.class, ":foo >", ":foo > ");
        this.appRegistry = appRegistry;
    }

    @Override
    public boolean shouldTrigger(String dslStart, Exception exception) {
        if (!super.shouldTrigger(dslStart, exception)) {
            return false;
        }
        return ((CheckPointedParseException)((Object)exception)).getExpressionStringUntilCheckpoint().trim().isEmpty();
    }

    @Override
    public void addProposals(String dsl, CheckPointedParseException exception, int detailLevel, List<CompletionProposal> proposals) {
        CompletionProposal.Factory completionFactory = CompletionProposal.expanding(dsl);
        for (AppRegistration appRegistration : this.appRegistry.findAll()) {
            if (appRegistration.getType() != ApplicationType.processor && appRegistration.getType() != ApplicationType.sink) continue;
            proposals.add(completionFactory.withSeparateTokens(appRegistration.getName(), "Wire destination into a " + appRegistration.getType() + " app"));
        }
    }
}

