/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingRecoveryStrategy;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;

public class AppsAfterDoublePipeRecoveryStrategy
extends StacktraceFingerprintingRecoveryStrategy<CheckPointedParseException> {
    private final AppRegistryService appRegistryService;

    AppsAfterDoublePipeRecoveryStrategy(AppRegistryService appRegistryService) {
        super(CheckPointedParseException.class, "foo ||", "foo || ");
        this.appRegistryService = appRegistryService;
    }

    @Override
    public void addProposals(String dsl, CheckPointedParseException exception, int detailLevel, List<CompletionProposal> collector) {
        StreamDefinition streamDefinition = new StreamDefinition("__dummy", exception.getExpressionStringUntilCheckpoint());
        CompletionProposal.Factory proposals = CompletionProposal.expanding(dsl);
        for (AppRegistration appRegistration : this.appRegistryService.findAll()) {
            if (appRegistration.getType() != ApplicationType.app) continue;
            String expansion = CompletionUtils.maybeQualifyWithLabel(appRegistration.getName(), streamDefinition);
            collector.add(proposals.withSeparateTokens(expansion, "Continue stream definition with a " + appRegistration.getType()));
        }
    }
}

