/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.completion.AddAppOptionsExpansionStrategy;
import org.springframework.cloud.dataflow.completion.AddAppOptionsTaskExpansionStrategy;
import org.springframework.cloud.dataflow.completion.AppsAfterDoublePipeRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.AppsAfterPipeRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.BooleanValueHintProvider;
import org.springframework.cloud.dataflow.completion.ConfigurationPropertyNameAfterDashDashRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.ConfigurationPropertyNameAfterDashDashTaskRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.ConfigurationPropertyValueHintExpansionStrategy;
import org.springframework.cloud.dataflow.completion.ConfigurationPropertyValueHintRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.ConfigurationPropertyValueHintTaskExpansionStrategy;
import org.springframework.cloud.dataflow.completion.ConfigurationPropertyValueHintTaskRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.DefaultValueHintProvider;
import org.springframework.cloud.dataflow.completion.DestinationNameYieldsAppsRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.EmptyStartYieldsSourceAppsTaskRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.EmptyStartYieldsSourceOrUnboundAppsRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.EnumValueHintProvider;
import org.springframework.cloud.dataflow.completion.ExpandOneDashToTwoDashesRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.ExpandOneDashToTwoDashesTaskRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.ExpansionStrategy;
import org.springframework.cloud.dataflow.completion.PipeIntoOtherAppsExpansionStrategy;
import org.springframework.cloud.dataflow.completion.RecoveryStrategy;
import org.springframework.cloud.dataflow.completion.StreamCompletionProvider;
import org.springframework.cloud.dataflow.completion.TaskCompletionProvider;
import org.springframework.cloud.dataflow.completion.TaskExpansionStrategy;
import org.springframework.cloud.dataflow.completion.UnfinishedAppNameExpansionStrategy;
import org.springframework.cloud.dataflow.completion.UnfinishedConfigurationPropertyNameRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.UnfinishedConfigurationPropertyNameTaskRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.UnfinishedTaskAppNameExpansionStrategy;
import org.springframework.cloud.dataflow.completion.ValueHintProvider;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolverAutoConfiguration;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ApplicationConfigurationMetadataResolverAutoConfiguration.class})
public class CompletionConfiguration {
    @Autowired
    private AppRegistryService appRegistry;
    @Autowired
    private ApplicationConfigurationMetadataResolver metadataResolver;

    @Bean
    public StreamCompletionProvider streamCompletionProvider() {
        List<RecoveryStrategy<?>> recoveryStrategies = Arrays.asList(this.emptyStartYieldsAppsRecoveryStrategy(), this.expandOneDashToTwoDashesRecoveryStrategy(), this.configurationPropertyNameAfterDashDashRecoveryStrategy(), this.unfinishedConfigurationPropertyNameRecoveryStrategy(), this.destinationNameYieldsAppsRecoveryStrategy(), this.appsAfterPipeRecoveryStrategy(), this.appsAfterDoublePipeRecoveryStrategy(), this.configurationPropertyValueHintRecoveryStrategy());
        List<ExpansionStrategy> expansionStrategies = Arrays.asList(this.addAppOptionsExpansionStrategy(), this.pipeIntoOtherAppsExpansionStrategy(), this.unfinishedAppNameExpansionStrategy(), this.configurationPropertyValueHintExpansionStrategy());
        return new StreamCompletionProvider(recoveryStrategies, expansionStrategies);
    }

    @Bean
    public RecoveryStrategy<?> emptyStartYieldsAppsRecoveryStrategy() {
        return new EmptyStartYieldsSourceOrUnboundAppsRecoveryStrategy(this.appRegistry);
    }

    @Bean
    public RecoveryStrategy<?> expandOneDashToTwoDashesRecoveryStrategy() {
        return new ExpandOneDashToTwoDashesRecoveryStrategy();
    }

    @Bean
    public ConfigurationPropertyNameAfterDashDashRecoveryStrategy configurationPropertyNameAfterDashDashRecoveryStrategy() {
        return new ConfigurationPropertyNameAfterDashDashRecoveryStrategy(this.appRegistry, this.metadataResolver);
    }

    @Bean
    public RecoveryStrategy<?> unfinishedConfigurationPropertyNameRecoveryStrategy() {
        return new UnfinishedConfigurationPropertyNameRecoveryStrategy(this.appRegistry, this.metadataResolver);
    }

    @Bean
    public RecoveryStrategy<?> appsAfterPipeRecoveryStrategy() {
        return new AppsAfterPipeRecoveryStrategy(this.appRegistry);
    }

    @Bean
    public RecoveryStrategy<?> appsAfterDoublePipeRecoveryStrategy() {
        return new AppsAfterDoublePipeRecoveryStrategy(this.appRegistry);
    }

    @Bean
    public RecoveryStrategy<?> destinationNameYieldsAppsRecoveryStrategy() {
        return new DestinationNameYieldsAppsRecoveryStrategy(this.appRegistry);
    }

    @Bean
    public RecoveryStrategy<?> configurationPropertyValueHintRecoveryStrategy() {
        return new ConfigurationPropertyValueHintRecoveryStrategy(this.appRegistry, this.metadataResolver);
    }

    @Bean
    public ExpansionStrategy addAppOptionsExpansionStrategy() {
        return new AddAppOptionsExpansionStrategy(this.appRegistry, this.metadataResolver);
    }

    @Bean
    public ExpansionStrategy unfinishedAppNameExpansionStrategy() {
        return new UnfinishedAppNameExpansionStrategy(this.appRegistry);
    }

    @Bean
    public ExpansionStrategy pipeIntoOtherAppsExpansionStrategy() {
        return new PipeIntoOtherAppsExpansionStrategy(this.appRegistry);
    }

    @Bean
    public ExpansionStrategy configurationPropertyValueHintExpansionStrategy() {
        return new ConfigurationPropertyValueHintExpansionStrategy(this.appRegistry, this.metadataResolver);
    }

    @Bean
    public ValueHintProvider defaultValueHintProvider() {
        return new DefaultValueHintProvider();
    }

    @Bean
    public ValueHintProvider enumValueHintProvider() {
        return new EnumValueHintProvider();
    }

    @Bean
    public ValueHintProvider booleanValueHintProvider() {
        return new BooleanValueHintProvider();
    }

    @Bean
    public TaskCompletionProvider taskCompletionProvider() {
        List<RecoveryStrategy<?>> recoveryStrategies = Arrays.asList(this.emptyStartYieldsAppsTaskRecoveryStrategy(), this.expandOneDashToTwoDashesTaskRecoveryStrategy(), this.configurationPropertyNameAfterDashDashTaskRecoveryStrategy(), this.unfinishedConfigurationPropertyNameTaskRecoveryStrategy(), this.configurationPropertyValueHintTaskRecoveryStrategy());
        List<TaskExpansionStrategy> expansionStrategies = Arrays.asList(this.addTaskAppOptionsExpansionStrategy(), this.unfinishedTaskAppNameExpansionStrategy(), this.taskConfigurationPropertyValueHintExpansionStrategy());
        return new TaskCompletionProvider(recoveryStrategies, expansionStrategies);
    }

    @Bean
    public RecoveryStrategy<?> emptyStartYieldsAppsTaskRecoveryStrategy() {
        return new EmptyStartYieldsSourceAppsTaskRecoveryStrategy(this.appRegistry);
    }

    @Bean
    public TaskExpansionStrategy addTaskAppOptionsExpansionStrategy() {
        return new AddAppOptionsTaskExpansionStrategy(this.appRegistry, this.metadataResolver);
    }

    @Bean
    public TaskExpansionStrategy unfinishedTaskAppNameExpansionStrategy() {
        return new UnfinishedTaskAppNameExpansionStrategy(this.appRegistry);
    }

    @Bean
    public TaskExpansionStrategy taskConfigurationPropertyValueHintExpansionStrategy() {
        return new ConfigurationPropertyValueHintTaskExpansionStrategy(this.appRegistry, this.metadataResolver);
    }

    @Bean
    public RecoveryStrategy<?> expandOneDashToTwoDashesTaskRecoveryStrategy() {
        return new ExpandOneDashToTwoDashesTaskRecoveryStrategy();
    }

    @Bean
    public ConfigurationPropertyNameAfterDashDashTaskRecoveryStrategy configurationPropertyNameAfterDashDashTaskRecoveryStrategy() {
        return new ConfigurationPropertyNameAfterDashDashTaskRecoveryStrategy(this.appRegistry, this.metadataResolver);
    }

    @Bean
    public RecoveryStrategy<?> configurationPropertyValueHintTaskRecoveryStrategy() {
        return new ConfigurationPropertyValueHintTaskRecoveryStrategy(this.appRegistry, this.metadataResolver);
    }

    @Bean
    public RecoveryStrategy<?> unfinishedConfigurationPropertyNameTaskRecoveryStrategy() {
        return new UnfinishedConfigurationPropertyNameTaskRecoveryStrategy(this.appRegistry, this.metadataResolver);
    }
}

