/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.ExpansionStrategy;
import org.springframework.cloud.dataflow.completion.RecoveryStrategy;
import org.springframework.cloud.dataflow.core.StreamDefinition;

public class StreamCompletionProvider {
    private final List<RecoveryStrategy<?>> completionRecoveryStrategies;
    private final List<ExpansionStrategy> completionExpansionStrategies;

    public StreamCompletionProvider(List<RecoveryStrategy<?>> completionRecoveryStrategies, List<ExpansionStrategy> completionExpansionStrategies) {
        this.completionRecoveryStrategies = new ArrayList(completionRecoveryStrategies);
        this.completionExpansionStrategies = new ArrayList<ExpansionStrategy>(completionExpansionStrategies);
    }

    public List<CompletionProposal> complete(String dslStart, int detailLevel) {
        StreamDefinition parsed;
        ArrayList<CompletionProposal> collector = new ArrayList<CompletionProposal>();
        try {
            parsed = new StreamDefinition("__dummy", dslStart);
        }
        catch (Exception recoverable) {
            for (RecoveryStrategy<?> strategy : this.completionRecoveryStrategies) {
                if (!strategy.shouldTrigger(dslStart, recoverable)) continue;
                strategy.addProposals(dslStart, recoverable, detailLevel, collector);
            }
            return collector;
        }
        for (ExpansionStrategy strategy : this.completionExpansionStrategies) {
            strategy.addProposals(dslStart, parsed, detailLevel, collector);
        }
        return collector;
    }

    public void addCompletionRecoveryStrategy(RecoveryStrategy recoveryStrategy) {
        this.completionRecoveryStrategies.add(recoveryStrategy);
    }
}

