/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.RecoveryStrategy;
import org.springframework.cloud.dataflow.completion.TaskExpansionStrategy;
import org.springframework.cloud.dataflow.core.TaskDefinition;

public class TaskCompletionProvider {
    private final List<RecoveryStrategy<?>> completionRecoveryStrategies;
    private final List<TaskExpansionStrategy> completionExpansionStrategies;

    public TaskCompletionProvider(List<RecoveryStrategy<?>> completionRecoveryStrategies, List<TaskExpansionStrategy> completionExpansionStrategies) {
        this.completionRecoveryStrategies = new ArrayList(completionRecoveryStrategies);
        this.completionExpansionStrategies = new ArrayList<TaskExpansionStrategy>(completionExpansionStrategies);
    }

    public List<CompletionProposal> complete(String dslStart, int detailLevel) {
        TaskDefinition parsed;
        ArrayList<CompletionProposal> collector = new ArrayList<CompletionProposal>();
        try {
            parsed = new TaskDefinition("__dummy", dslStart);
        }
        catch (Exception recoverable) {
            for (RecoveryStrategy<?> strategy : this.completionRecoveryStrategies) {
                if (!strategy.shouldTrigger(dslStart, recoverable)) continue;
                strategy.addProposals(dslStart, recoverable, detailLevel, collector);
            }
            return collector;
        }
        for (TaskExpansionStrategy strategy : this.completionExpansionStrategies) {
            strategy.addProposals(dslStart, parsed, detailLevel, collector);
        }
        return collector;
    }

    public void addCompletionRecoveryStrategy(RecoveryStrategy<?> recoveryStrategy) {
        this.completionRecoveryStrategies.add(recoveryStrategy);
    }
}

