/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.configuration.metadata;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataGroup;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepositoryJsonBuilder;
import org.springframework.boot.configurationmetadata.Deprecation;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.ExplodedArchive;
import org.springframework.boot.loader.archive.JarFileArchive;
import org.springframework.boot.loader.jar.JarFile;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.configuration.metadata.BootClassLoaderFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

public class BootApplicationConfigurationMetadataResolver
extends ApplicationConfigurationMetadataResolver {
    private static final String CONFIGURATION_METADATA_PATTERN = "classpath*:/META-INF/spring-configuration-metadata.json";
    private static final String WHITELIST_LEGACY_PROPERTIES = "classpath*:/META-INF/spring-configuration-metadata-whitelist.properties";
    private static final String WHITELIST_PROPERTIES = "classpath*:/META-INF/dataflow-configuration-metadata-whitelist.properties";
    private static final String CONFIGURATION_PROPERTIES_CLASSES = "configuration-properties.classes";
    private static final String CONFIGURATION_PROPERTIES_NAMES = "configuration-properties.names";
    private final Set<String> globalWhiteListedProperties = new HashSet<String>();
    private final Set<String> globalWhiteListedClasses = new HashSet<String>();
    private final ClassLoader parent;

    public BootApplicationConfigurationMetadataResolver() {
        this(null);
    }

    public BootApplicationConfigurationMetadataResolver(ClassLoader parent) {
        this.parent = parent;
        JarFile.registerUrlProtocolHandler();
        try {
            Resource[] globalLegacyResources = new PathMatchingResourcePatternResolver(ApplicationConfigurationMetadataResolver.class.getClassLoader()).getResources(WHITELIST_LEGACY_PROPERTIES);
            Resource[] globalResources = new PathMatchingResourcePatternResolver(ApplicationConfigurationMetadataResolver.class.getClassLoader()).getResources(WHITELIST_PROPERTIES);
            this.loadWhiteLists(BootApplicationConfigurationMetadataResolver.concatArrays(globalLegacyResources, globalResources), this.globalWhiteListedClasses, this.globalWhiteListedProperties);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading global white list of configuration properties", e);
        }
    }

    private static Resource[] concatArrays(Resource[] ... arrays) {
        return (Resource[])Arrays.stream(arrays).flatMap(Arrays::stream).toArray(Resource[]::new);
    }

    @Override
    public List<ConfigurationMetadataProperty> listProperties(Resource app, boolean exhaustive) {
        try {
            if (app != null) {
                Archive archive = this.resolveAsArchive(app);
                return this.listProperties(archive, exhaustive);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to resolve application resource: " + app.getDescription());
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ConfigurationMetadataProperty> listProperties(Archive archive, boolean exhaustive) {
        try (URLClassLoader moduleClassLoader = new BootClassLoaderFactory(archive, this.parent).createClassLoader();){
            ArrayList<ConfigurationMetadataProperty> result = new ArrayList<ConfigurationMetadataProperty>();
            PathMatchingResourcePatternResolver moduleResourceLoader = new PathMatchingResourcePatternResolver((ClassLoader)moduleClassLoader);
            HashSet<String> whiteListedClasses = new HashSet<String>(this.globalWhiteListedClasses);
            HashSet<String> whiteListedProperties = new HashSet<String>(this.globalWhiteListedProperties);
            Resource[] whitelistLegacyDescriptors = moduleResourceLoader.getResources(WHITELIST_LEGACY_PROPERTIES);
            Resource[] whitelistDescriptors = moduleResourceLoader.getResources(WHITELIST_PROPERTIES);
            this.loadWhiteLists(BootApplicationConfigurationMetadataResolver.concatArrays(whitelistLegacyDescriptors, whitelistDescriptors), whiteListedClasses, whiteListedProperties);
            ConfigurationMetadataRepositoryJsonBuilder builder = ConfigurationMetadataRepositoryJsonBuilder.create();
            for (Resource r : moduleResourceLoader.getResources(CONFIGURATION_METADATA_PATTERN)) {
                builder.withJsonResource(r.getInputStream());
            }
            for (ConfigurationMetadataGroup group : builder.build().getAllGroups().values()) {
                if (exhaustive || this.isWhiteListed(group, whiteListedClasses)) {
                    for (ConfigurationMetadataProperty property : group.getProperties().values()) {
                        if (this.isDeprecatedError(property)) continue;
                        result.add(property);
                    }
                    continue;
                }
                if ("_ROOT_GROUP_".equals(group.getId())) {
                    for (ConfigurationMetadataProperty property : group.getProperties().values()) {
                        if (!this.isWhiteListed(property, whiteListedProperties) || this.isDeprecatedError(property)) continue;
                        result.add(property);
                    }
                    continue;
                }
                for (ConfigurationMetadataProperty property : group.getProperties().values()) {
                    if (!this.isWhiteListed(property, whiteListedProperties) || this.isDeprecatedError(property)) continue;
                    result.add(property);
                }
            }
            ArrayList<ConfigurationMetadataProperty> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception trying to list configuration properties for application " + archive, e);
        }
    }

    @Override
    public URLClassLoader createAppClassLoader(Resource app) {
        try {
            return new BootClassLoaderFactory(this.resolveAsArchive(app), this.parent).createClassLoader();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to resolve application resource: " + app.getDescription(), e);
        }
    }

    private Archive resolveAsArchive(Resource app) throws IOException {
        File moduleFile = app.getFile();
        return moduleFile.isDirectory() ? new ExplodedArchive(moduleFile) : new JarFileArchive(moduleFile);
    }

    private void loadWhiteLists(Resource[] resources, Collection<String> classes, Collection<String> names) throws IOException {
        for (Resource resource : resources) {
            Properties properties = new Properties();
            properties.load(resource.getInputStream());
            classes.addAll(Arrays.asList(StringUtils.delimitedListToStringArray((String)properties.getProperty(CONFIGURATION_PROPERTIES_CLASSES), (String)",", (String)" ")));
            names.addAll(Arrays.asList(StringUtils.delimitedListToStringArray((String)properties.getProperty(CONFIGURATION_PROPERTIES_NAMES), (String)",", (String)" ")));
        }
    }

    private boolean isWhiteListed(ConfigurationMetadataProperty property, Collection<String> properties) {
        return properties.contains(property.getId());
    }

    private boolean isDeprecatedError(ConfigurationMetadataProperty property) {
        return property.getDeprecation() != null && property.getDeprecation().getLevel() == Deprecation.Level.ERROR;
    }

    private boolean isWhiteListed(ConfigurationMetadataGroup group, Collection<String> classes) {
        Set sourceTypes = group.getSources().keySet();
        return !sourceTypes.isEmpty() && classes.containsAll(sourceTypes);
    }
}

