/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.configuration.metadata.container;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.dataflow.configuration.metadata.AppMetadataResolutionException;
import org.springframework.cloud.dataflow.configuration.metadata.container.ContainerImage;
import org.springframework.cloud.dataflow.configuration.metadata.container.ContainerImageMetadataResolver;
import org.springframework.cloud.dataflow.configuration.metadata.container.ContainerImageParser;
import org.springframework.cloud.dataflow.configuration.metadata.container.RegistryConfiguration;
import org.springframework.cloud.dataflow.configuration.metadata.container.authorization.RegistryAuthorizer;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultContainerImageMetadataResolver
implements ContainerImageMetadataResolver {
    private static final List<String> SUPPORTED_MANIFEST_MEDIA_TYPES = Collections.unmodifiableList(Arrays.asList("application/vnd.oci.image.manifest.v1+json", "application/vnd.docker.distribution.manifest.v2+json"));
    private final RestTemplate containerRestTemplate;
    private RestTemplate noSslVerificationContainerRestTemplate;
    private final ContainerImageParser containerImageParser;
    private final Map<RegistryConfiguration.AuthorizationType, RegistryAuthorizer> registryAuthorizerMap;
    private Map<String, RegistryConfiguration> registryConfigurationMap;

    public DefaultContainerImageMetadataResolver(RestTemplate restTemplate, RestTemplate noSslVerificationContainerRestTemplate, ContainerImageParser containerImageParser, Map<String, RegistryConfiguration> registryConfigurationMap, List<RegistryAuthorizer> registryAuthorizes) {
        this.containerRestTemplate = restTemplate;
        this.noSslVerificationContainerRestTemplate = noSslVerificationContainerRestTemplate;
        this.containerImageParser = containerImageParser;
        this.registryConfigurationMap = registryConfigurationMap;
        this.registryAuthorizerMap = new HashMap<RegistryConfiguration.AuthorizationType, RegistryAuthorizer>();
        for (RegistryAuthorizer authorizer : registryAuthorizes) {
            this.registryAuthorizerMap.put(authorizer.getType(), authorizer);
        }
    }

    @Override
    public Map<String, String> getImageLabels(String imageName) {
        if (!StringUtils.hasText((String)imageName)) {
            throw new AppMetadataResolutionException("Null or empty image name");
        }
        RegistryRequest registryRequest = this.getRegistryRequest(imageName);
        Map manifest = this.getImageManifest(registryRequest, Map.class);
        if (!this.isNotNullMap(manifest.get("config"))) {
            throw new AppMetadataResolutionException(String.format("Image [%s] has incorrect or missing manifest config element: %s", imageName, manifest.toString()));
        }
        String configDigest = (String)((Map)manifest.get("config")).get("digest");
        if (!StringUtils.hasText((String)configDigest)) {
            throw new AppMetadataResolutionException(String.format("Missing or invalid Configuration Digest: [%s] for image [%s]", configDigest, imageName));
        }
        String configBlob = this.getImageBlob(registryRequest, configDigest, String.class);
        try {
            Map configBlobMap = (Map)new ObjectMapper().readValue(configBlob, Map.class);
            if (!this.isNotNullMap(configBlobMap.get("config"))) {
                throw new AppMetadataResolutionException(String.format("Configuration json for image [%s] with digest [%s] has incorrect Config Blog element", imageName, configDigest));
            }
            Map configElement = (Map)configBlobMap.get("config");
            return this.isNotNullMap(configElement.get("Labels")) ? (Map)configElement.get("Labels") : Collections.emptyMap();
        }
        catch (JsonProcessingException e) {
            throw new AppMetadataResolutionException("Unable to extract the labels from the Config blob", e);
        }
    }

    private boolean isNotNullMap(Object object) {
        return object != null && object instanceof Map;
    }

    private RegistryRequest getRegistryRequest(String imageName) {
        ContainerImage containerImage = this.containerImageParser.parse(imageName);
        RegistryConfiguration registryConf = this.registryConfigurationMap.get(containerImage.getRegistryHost());
        RegistryAuthorizer registryAuthorizer = this.registryAuthorizerMap.get((Object)registryConf.getAuthorizationType());
        if (registryAuthorizer == null) {
            throw new AppMetadataResolutionException("Could not find an RegistryAuthorizer of type:" + (Object)((Object)registryConf.getAuthorizationType()));
        }
        HttpHeaders authHttpHeaders = registryAuthorizer.getAuthorizationHeaders(containerImage, registryConf);
        if (authHttpHeaders == null) {
            throw new AppMetadataResolutionException("Could not obtain authorized headers for: " + containerImage + ", config:" + registryConf);
        }
        RestTemplate requestRestTemplate = registryConf.isDisableSslVerification() ? this.noSslVerificationContainerRestTemplate : this.containerRestTemplate;
        return new RegistryRequest(containerImage, registryConf, authHttpHeaders, requestRestTemplate);
    }

    private <T> T getImageManifest(RegistryRequest registryRequest, Class<T> responseClassType) {
        String imageManifestMediaType = registryRequest.getRegistryConf().getManifestMediaType();
        if (!SUPPORTED_MANIFEST_MEDIA_TYPES.contains(imageManifestMediaType)) {
            throw new AppMetadataResolutionException("Not supported image manifest media type:" + imageManifestMediaType);
        }
        HttpHeaders httpHeaders = new HttpHeaders((MultiValueMap)registryRequest.getAuthHttpHeaders());
        httpHeaders.set("Accept", imageManifestMediaType);
        ContainerImage containerImage = registryRequest.getContainerImage();
        UriComponents manifestUriComponents = UriComponentsBuilder.newInstance().scheme("https").host(containerImage.getHostname()).port(StringUtils.hasText((String)containerImage.getPort()) ? containerImage.getPort() : null).path("v2/{repository}/manifests/{tag}").build().expand(new Object[]{containerImage.getRepository(), containerImage.getRepositoryTag()});
        ResponseEntity manifest = registryRequest.getRestTemplate().exchange(manifestUriComponents.toUri(), HttpMethod.GET, new HttpEntity((MultiValueMap)httpHeaders), responseClassType);
        return (T)manifest.getBody();
    }

    private <T> T getImageBlob(RegistryRequest registryRequest, String configDigest, Class<T> responseClassType) {
        ContainerImage containerImage = registryRequest.getContainerImage();
        HttpHeaders httpHeaders = new HttpHeaders((MultiValueMap)registryRequest.getAuthHttpHeaders());
        UriComponents blobUriComponents = UriComponentsBuilder.newInstance().scheme("https").host(containerImage.getHostname()).port(StringUtils.hasText((String)containerImage.getPort()) ? containerImage.getPort() : null).path("v2/{repository}/blobs/{digest}").build().expand(new Object[]{containerImage.getRepository(), configDigest});
        ResponseEntity blob = registryRequest.getRestTemplate().exchange(blobUriComponents.toUri(), HttpMethod.GET, new HttpEntity((MultiValueMap)httpHeaders), responseClassType);
        return (T)blob.getBody();
    }

    public static class RegistryRequest {
        private final ContainerImage containerImage;
        private final RegistryConfiguration registryConf;
        private final HttpHeaders authHttpHeaders;
        private final RestTemplate restTemplate;

        public RegistryRequest(ContainerImage containerImage, RegistryConfiguration registryConf, HttpHeaders authHttpHeaders, RestTemplate requestRestTemplate) {
            this.containerImage = containerImage;
            this.registryConf = registryConf;
            this.authHttpHeaders = authHttpHeaders;
            this.restTemplate = requestRestTemplate;
        }

        public ContainerImage getContainerImage() {
            return this.containerImage;
        }

        public RegistryConfiguration getRegistryConf() {
            return this.registryConf;
        }

        public HttpHeaders getAuthHttpHeaders() {
            return this.authHttpHeaders;
        }

        public RestTemplate getRestTemplate() {
            return this.restTemplate;
        }
    }
}

