/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.configuration.metadata.container.authorization;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.configuration.metadata.container.RegistryConfiguration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class DockerConfigJsonSecretToRegistryConfigurationConverter
implements Converter<String, Map<String, RegistryConfiguration>> {
    private static final Logger logger = LoggerFactory.getLogger(DockerConfigJsonSecretToRegistryConfigurationConverter.class);
    private RestTemplate restTemplate;

    public DockerConfigJsonSecretToRegistryConfigurationConverter(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public Map<String, RegistryConfiguration> convert(String dockerconfigjson) {
        if (StringUtils.hasText((String)dockerconfigjson)) {
            try {
                Map authsMap = (Map)((Map)new ObjectMapper().readValue(dockerconfigjson, Map.class)).get("auths");
                HashMap<String, RegistryConfiguration> registryConfigurationMap = new HashMap<String, RegistryConfiguration>();
                for (Object registryUrl : authsMap.keySet()) {
                    RegistryConfiguration rc = new RegistryConfiguration();
                    rc.setRegistryHost(registryUrl.toString());
                    Map registryMap = (Map)authsMap.get(registryUrl.toString());
                    rc.setUser((String)registryMap.get("username"));
                    rc.setSecret((String)registryMap.get("password"));
                    String tokenAccessUrl = this.getDockerTokenServiceUri(rc.getRegistryHost(), rc.getUser(), rc.getSecret());
                    if (StringUtils.isEmpty((Object)tokenAccessUrl)) {
                        rc.setAuthorizationType(RegistryConfiguration.AuthorizationType.basicauth);
                    } else {
                        rc.setAuthorizationType(RegistryConfiguration.AuthorizationType.dockeroauth2);
                        rc.getExtra().put("registryAuthUri", tokenAccessUrl);
                    }
                    logger.info("Registry Secret: " + rc.toString());
                    registryConfigurationMap.put(rc.getRegistryHost(), rc);
                }
                return registryConfigurationMap;
            }
            catch (Exception e) {
                logger.error("Failed to parse the Secret:" + dockerconfigjson);
            }
        }
        return Collections.emptyMap();
    }

    public String getDockerTokenServiceUri(String registryHost, String username, String password) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (StringUtils.hasText((String)username) && StringUtils.hasText((String)password)) {
            httpHeaders.setBasicAuth(username, password);
        }
        try {
            this.restTemplate.exchange(UriComponentsBuilder.newInstance().scheme("https").host(registryHost).path("v2/_catalog").build().toUri(), HttpMethod.GET, new HttpEntity((MultiValueMap)httpHeaders), Map.class);
            return null;
        }
        catch (HttpClientErrorException httpError) {
            if (httpError.getRawStatusCode() != 401) {
                return null;
            }
            if (!httpError.getResponseHeaders().containsKey((Object)"Www-Authenticate")) {
                return null;
            }
            List wwwAuthenticate = httpError.getResponseHeaders().get((Object)"Www-Authenticate");
            logger.info("" + wwwAuthenticate);
            Map<String, String> wwwAuthenticateAttributes = Stream.of(((String)wwwAuthenticate.get(0)).split(",")).map(s -> s.split("=")).collect(Collectors.toMap(b -> b[0], b -> b[1]));
            String tokenServiceUri = String.format("%s?service=%s&scope=repository:{repository}:pull", wwwAuthenticateAttributes.get("Bearer realm"), wwwAuthenticateAttributes.get("service"));
            tokenServiceUri = tokenServiceUri.replaceAll("\"", "");
            logger.info("tokenServiceUri: " + tokenServiceUri);
            return tokenServiceUri;
        }
        catch (Exception e) {
            return null;
        }
    }
}

