/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.registry.service;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.audit.service.AuditRecordService;
import org.springframework.cloud.dataflow.audit.service.AuditServiceUtils;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.AuditActionType;
import org.springframework.cloud.dataflow.core.AuditOperationType;
import org.springframework.cloud.dataflow.registry.repository.AppRegistrationRepository;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;
import org.springframework.cloud.dataflow.registry.support.AppResourceCommon;
import org.springframework.cloud.dataflow.registry.support.NoSuchAppRegistrationException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Transactional
public class DefaultAppRegistryService
implements AppRegistryService {
    public static final String METADATA_KEY_SUFFIX = "metadata";
    protected static final Logger logger = LoggerFactory.getLogger(DefaultAppRegistryService.class);
    private final AppRegistrationRepository appRegistrationRepository;
    private AppResourceCommon appResourceCommon;
    protected final AuditRecordService auditRecordService;
    protected final AuditServiceUtils auditServiceUtils;
    protected static final Function<Map.Entry<Object, Object>, AbstractMap.SimpleImmutableEntry<String, URI>> toStringAndUriFunc = kv -> {
        try {
            return new AbstractMap.SimpleImmutableEntry<String, URI>((String)kv.getKey(), new URI((String)kv.getValue()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    };

    public DefaultAppRegistryService(AppRegistrationRepository appRegistrationRepository, AppResourceCommon appResourceCommon, AuditRecordService auditRecordService) {
        Assert.notNull((Object)appResourceCommon, (String)"'appResourceCommon' must not be null");
        Assert.notNull((Object)appRegistrationRepository, (String)"'appRegistrationRepository' must not be null");
        Assert.notNull((Object)auditRecordService, (String)"'auditRecordService' must not be null");
        this.appResourceCommon = appResourceCommon;
        this.appRegistrationRepository = appRegistrationRepository;
        this.auditRecordService = auditRecordService;
        this.auditServiceUtils = new AuditServiceUtils();
    }

    @Override
    public AppRegistration find(String name, ApplicationType type) {
        return this.getDefaultApp(name, type);
    }

    @Override
    public AppRegistration find(String name, ApplicationType type, String version) {
        return this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndVersion(name, type, version);
    }

    @Override
    public AppRegistration getDefaultApp(String name, ApplicationType type) {
        return this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndDefaultVersionIsTrue(name, type);
    }

    @Override
    public void setDefaultApp(String name, ApplicationType type, String version) {
        AppRegistration newDefault;
        AppRegistration oldDefault = this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndDefaultVersionIsTrue(name, type);
        if (oldDefault != null) {
            oldDefault.setDefaultVersion(Boolean.valueOf(false));
            this.appRegistrationRepository.save(oldDefault);
        }
        if ((newDefault = this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndVersion(name, type, version)) == null) {
            throw new NoSuchAppRegistrationException(name, type, version);
        }
        newDefault.setDefaultVersion(Boolean.valueOf(true));
        this.appRegistrationRepository.save(newDefault);
        this.auditRecordService.populateAndSaveAuditRecordUsingMapData(AuditOperationType.APP_REGISTRATION, AuditActionType.UPDATE, newDefault.getName(), this.auditServiceUtils.convertAppRegistrationToAuditData(newDefault));
    }

    @Override
    public List<AppRegistration> findAll() {
        return this.appRegistrationRepository.findAll();
    }

    @Override
    public Page<AppRegistration> findAllByTypeAndNameIsLike(ApplicationType type, String name, Pageable pageable) {
        if (!StringUtils.hasText((String)name) && type == null) {
            return this.findAll(pageable);
        }
        if (StringUtils.hasText((String)name) && type == null) {
            return this.appRegistrationRepository.findAllByNameContainingIgnoreCase(name, pageable);
        }
        if (StringUtils.hasText((String)name)) {
            return this.appRegistrationRepository.findAllByTypeAndNameContainingIgnoreCase(type, name, pageable);
        }
        return this.appRegistrationRepository.findAllByType(type, pageable);
    }

    @Override
    public Page<AppRegistration> findAll(Pageable pageable) {
        return this.appRegistrationRepository.findAll(pageable);
    }

    @Override
    public AppRegistration save(String name, ApplicationType type, String version, URI uri, URI metadataUri) {
        return this.save(new AppRegistration(name, type, version, uri, metadataUri));
    }

    @Override
    public AppRegistration save(AppRegistration app) {
        AppRegistration createdApp;
        AppRegistration appRegistration = this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndVersion(app.getName(), app.getType(), app.getVersion());
        if (appRegistration != null) {
            appRegistration.setUri(app.getUri());
            appRegistration.setMetadataUri(app.getMetadataUri());
            createdApp = this.appRegistrationRepository.save(appRegistration);
            this.populateAuditData(AuditActionType.UPDATE, createdApp);
        } else {
            if (this.getDefaultApp(app.getName(), app.getType()) == null) {
                app.setDefaultVersion(Boolean.valueOf(true));
            }
            createdApp = this.appRegistrationRepository.save(app);
            this.populateAuditData(AuditActionType.CREATE, createdApp);
        }
        return createdApp;
    }

    private void populateAuditData(AuditActionType auditActionType, AppRegistration appRegistration) {
        if (appRegistration == null) {
            logger.error("App registration failed, app not saved into database!");
        } else {
            this.auditRecordService.populateAndSaveAuditRecordUsingMapData(AuditOperationType.APP_REGISTRATION, auditActionType, appRegistration.getName(), this.auditServiceUtils.convertAppRegistrationToAuditData(appRegistration));
        }
    }

    @Override
    public void delete(String name, ApplicationType type, String version) {
        this.appRegistrationRepository.deleteAppRegistrationByNameAndTypeAndVersion(name, type, version);
        this.populateAuditData(AuditActionType.DELETE, new AppRegistration(name, type, version, URI.create(""), URI.create("")));
    }

    @Override
    public void deleteAll(Iterable<AppRegistration> appRegistrations) {
        this.appRegistrationRepository.deleteAll(appRegistrations);
    }

    protected boolean isOverwrite(AppRegistration app, boolean overwrite) {
        return overwrite || this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndVersion(app.getName(), app.getType(), app.getVersion()) == null;
    }

    @Override
    public boolean appExist(String name, ApplicationType type) {
        return this.getDefaultApp(name, type) != null;
    }

    @Override
    public boolean appExist(String name, ApplicationType type, String version) {
        return this.find(name, type, version) != null;
    }

    @Override
    public Resource getAppResource(AppRegistration appRegistration) {
        return this.appResourceCommon.getResource(appRegistration.getUri().toString());
    }

    @Override
    public Resource getAppMetadataResource(AppRegistration appRegistration) {
        return this.appResourceCommon.getMetadataResource(appRegistration.getUri(), appRegistration.getMetadataUri());
    }

    @Override
    public String getResourceVersion(Resource resource) {
        return this.appResourceCommon.getResourceVersion(resource);
    }

    @Override
    public String getResourceWithoutVersion(Resource resource) {
        return this.appResourceCommon.getResourceWithoutVersion(resource);
    }

    @Override
    public String getResourceVersion(String uriString) {
        return this.getResourceVersion(this.appResourceCommon.getResource(uriString));
    }

    private String getVersionOrBroken(String uri) {
        try {
            return this.getResourceVersion(uri);
        }
        catch (IllegalStateException ise) {
            logger.warn("", (Throwable)ise);
            return "broken";
        }
    }

    protected Properties loadProperties(Resource resource) {
        try {
            return PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from " + resource.getDescription(), e);
        }
    }

    @Override
    public List<AppRegistration> importAll(boolean overwrite, Resource ... resources) {
        return Stream.of(resources).map(this::loadProperties).flatMap(prop -> prop.entrySet().stream().map(toStringAndUriFunc).flatMap(kv -> this.toValidAppRegistration((Map.Entry<String, URI>)kv, this.metadataUriFromProperties((String)kv.getKey(), (Properties)prop))).filter(a -> this.isOverwrite((AppRegistration)a, overwrite)).map(ar -> this.save((AppRegistration)ar))).collect(Collectors.toList());
    }

    protected Stream<AppRegistration> toValidAppRegistration(Map.Entry<String, URI> kv, URI metadataURI) {
        String key = kv.getKey();
        String[] tokens = key.split("\\.");
        if (tokens.length == 2) {
            String name = tokens[1];
            ApplicationType type = ApplicationType.valueOf((String)tokens[0]);
            URI appURI = this.warnOnMalformedURI(key, kv.getValue());
            String version = this.getVersionOrBroken(appURI.toString());
            return Stream.of(new AppRegistration(name, type, version, appURI, metadataURI));
        }
        Assert.isTrue((tokens.length == 3 && METADATA_KEY_SUFFIX.equals(tokens[2]) ? 1 : 0) != 0, (String)("Invalid format for app key '" + key + "'in file. Must be <type>.<name> or <type>.<name>.metadata"));
        return Stream.empty();
    }

    protected URI metadataUriFromProperties(String key, Properties properties) {
        String metadataValue = properties.getProperty(key + "." + METADATA_KEY_SUFFIX);
        try {
            return metadataValue != null ? this.warnOnMalformedURI(key, new URI(metadataValue)) : null;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected URI warnOnMalformedURI(String key, URI uri) {
        if (StringUtils.isEmpty((Object)uri)) {
            logger.warn(String.format("Error when registering '%s': URI is required", key));
        } else if (!StringUtils.hasText((String)uri.getScheme())) {
            logger.warn(String.format("Error when registering '%s' with URI %s: URI scheme must be specified", key, uri));
        } else if (!StringUtils.hasText((String)uri.getSchemeSpecificPart())) {
            logger.warn(String.format("Error when registering '%s' with URI %s: URI scheme-specific part must be specified", key, uri));
        }
        return uri;
    }
}

